package com.dji.wpmzsdk.common.utils.kml;

import android.text.TextUtils;

import com.dji.wpmzsdk.common.utils.kml.data.MissionType;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionFinishedAction;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionHeadingMode;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointV2MissionTypes;
import com.dji.wpmzsdk.common.utils.kml.model.MappingCameraType;
import com.dji.wpmzsdk.common.utils.kml.model.WaypointActionType;
import com.dji.wpmzsdk.common.utils.kml.model.PointTurnMode;
import com.dji.wpmzsdk.common.utils.kml.model.WaypointDroneType;


/**
 * 用于航线中的枚举对象和String之间的转换
 *
 * @author bryan.jia
 */
public class KMLValueConverter {

    public static String convert(PointTurnMode turnMode) {
        switch (turnMode) {
            case CLOCKWISE:
                return KMLConstants.TURN_MODE_CLOCKWISE;
            case COUNTER_CLOCKWISE:
                return KMLConstants.TURN_MODE_COUNTERCLOCKWISE;
            case AUTO:
                return KMLConstants.TURN_MODE_AUTO;
            default:
                return KMLConstants.TURN_MODE_CLOCKWISE;
        }
    }

    public static String convert(WaypointMissionFinishedAction finishedAction) {
        switch (finishedAction) {
            case NO_ACTION:
                return KMLConstants.FINISHED_ACTION_HOVER;
            case GO_HOME:
                return KMLConstants.FINISHED_ACTION_GO_HOME;
            case AUTO_LAND:
                return KMLConstants.FINISHED_ACTION_AUTO_LAND;
            case GO_FIRST_WAYPOINT:
                return KMLConstants.FINISHED_ACTION_GO_FIRST_POINT;
            default:
                return KMLConstants.FINISHED_ACTION_HOVER;
        }
    }

    public static String convert(WaypointMissionHeadingMode headingMode) {
        switch (headingMode) {
            case AUTO:
                return KMLConstants.HEADING_AUTO;
            case CONTROL_BY_REMOTE_CONTROLLER:
                return KMLConstants.CONTROLLED_BY_RC;
            case USING_WAYPOINT_HEADING:
                return KMLConstants.USE_POINT_SETTING;
            case TOWARD_POINT_OF_INTEREST:
                return KMLConstants.HEADING_TOWARDS_POI;
            case USING_INITIAL_DIRECTION:
                return KMLConstants.USING_INITIAL_DIRECTION;
            default:
                return KMLConstants.HEADING_AUTO;
        }
    }

    public static String convert(WaypointActionType actionType) {
        switch (actionType) {
            case STAY:
                return KMLConstants.TEXT_ACTION_HOVERING;
            case START_TAKE_PHOTO:
                return KMLConstants.TEXT_ACTION_SHOOT_PHOTO;
            case START_RECORD:
                return KMLConstants.TEXT_ACTION_START_RECORDING;
            case STOP_RECORD:
                return KMLConstants.TEXT_ACTION_STOP_RECORDING;
            case ROTATE_AIRCRAFT:
                return KMLConstants.TEXT_ACTION_AIRCRAFT_YAW;
            case GIMBAL_PITCH:
                return KMLConstants.TEXT_ACTION_GIMBAL_PITCH;
            case GIMBAL_YAW:
                return KMLConstants.TEXT_ACTION_GIMBAL_YAW;
            case CAMERA_ZOOM:
                return KMLConstants.TEXT_ACTION_CAMERA_ZOOM;
            case CAMERA_FOCUS:
                return KMLConstants.TEXT_ACTION_CAMERA_FOCUS;
            case START_TIME_INTERVAL_SHOT:
                return KMLConstants.TEXT_ACTION_TIME_INTERVAL_SHOT;
            case START_DISTANCE_INTERVAL_SHOT:
                return KMLConstants.TEXT_ACTION_DISTANCE_INTERVAL_SHOT;
            case STOP_INTERVAL_SHOT:
                return KMLConstants.TEXT_ACTION_STOP_INTERVAL_SHOT;
            case PRECISE_SHOT:
                return KMLConstants.TEXT_ACTION_PRECISE_SHOT;
            case PAYLOAD_BUTTON:
                return KMLConstants.TEXT_ACTION_PAYLOAD_BUTTON;
            case PAYLOAD_SWITCH_ON:
                return KMLConstants.TEXT_ACTION_PAYLOAD_SWITCH_ON;
            case PAYLOAD_SWITCH_OFF:
                return KMLConstants.TEXT_ACTION_PAYLOAD_SWITCH_OFF;
            case PAYLOAD_SEEK_VALUE:
                return KMLConstants.TEXT_ACTION_PAYLOAD_SEEK;
            case START_POINT_CLOUD:
                return KMLConstants.TEXT_ACTION_START_POINT_CLOUD;
            case PAUSE_POINT_CLOUD:
                return KMLConstants.TEXT_ACTION_PAUSE_POINT_CLOUD;
            case CONTINUE_POINT_CLOUD:
                return KMLConstants.TEXT_ACTION_CONTINUE_POINT_CLOUD;
            case FINISH_POINT_CLOUD:
                return KMLConstants.TEXT_ACTION_FINISH_POINT_CLOUD;
            case CAMERA_MKDIR:
                return KMLConstants.TEXT_ACTION_CAMERA_MKDIR;
            default:
                return null;
        }

    }

    public static WaypointActionType getActionType(String type) {
        if (equals(type, KMLConstants.TEXT_ACTION_HOVERING)) {
            return WaypointActionType.STAY;
        } else if (equals(type, KMLConstants.TEXT_ACTION_SHOOT_PHOTO)) {
            return WaypointActionType.START_TAKE_PHOTO;
        } else if (equals(type, KMLConstants.TEXT_ACTION_START_RECORDING)) {
            return WaypointActionType.START_RECORD;
        } else if (equals(type, KMLConstants.TEXT_ACTION_STOP_RECORDING)) {
            return WaypointActionType.STOP_RECORD;
        } else if (equals(type, KMLConstants.TEXT_ACTION_AIRCRAFT_YAW)) {
            return WaypointActionType.ROTATE_AIRCRAFT;
        } else if (equals(type, KMLConstants.TEXT_ACTION_GIMBAL_PITCH)) {
            return WaypointActionType.GIMBAL_PITCH;
        } else if (equals(type, KMLConstants.TEXT_ACTION_GIMBAL_YAW)) {
            return WaypointActionType.GIMBAL_YAW;
        } else if (equals(type, KMLConstants.TEXT_ACTION_CAMERA_ZOOM)) {
            return WaypointActionType.CAMERA_ZOOM;
        } else if (equals(type, KMLConstants.TEXT_ACTION_CAMERA_FOCUS)) {
            return WaypointActionType.CAMERA_FOCUS;
        } else if (equals(type, KMLConstants.TEXT_ACTION_TIME_INTERVAL_SHOT)) {
            return WaypointActionType.START_TIME_INTERVAL_SHOT;
        } else if (equals(type, KMLConstants.TEXT_ACTION_DISTANCE_INTERVAL_SHOT)) {
            return WaypointActionType.START_DISTANCE_INTERVAL_SHOT;
        } else if (equals(type, KMLConstants.TEXT_ACTION_STOP_INTERVAL_SHOT)) {
            return WaypointActionType.STOP_INTERVAL_SHOT;
        } else if (equals(type, KMLConstants.TEXT_ACTION_PRECISE_SHOT)) {
            return WaypointActionType.PRECISE_SHOT;
        } else if (equals(type, KMLConstants.TEXT_ACTION_PAYLOAD_BUTTON)) {
            return WaypointActionType.PAYLOAD_BUTTON;
        } else if (equals(type, KMLConstants.TEXT_ACTION_PAYLOAD_SWITCH_ON)) {
            return WaypointActionType.PAYLOAD_SWITCH_ON;
        } else if (equals(type, KMLConstants.TEXT_ACTION_PAYLOAD_SWITCH_OFF)) {
            return WaypointActionType.PAYLOAD_SWITCH_OFF;
        } else if (equals(type, KMLConstants.TEXT_ACTION_PAYLOAD_SEEK)) {
            return WaypointActionType.PAYLOAD_SEEK_VALUE;
        } else if (equals(type, KMLConstants.TEXT_ACTION_START_POINT_CLOUD)) {
            return WaypointActionType.START_POINT_CLOUD;
        } else if (equals(type, KMLConstants.TEXT_ACTION_PAUSE_POINT_CLOUD)) {
            return WaypointActionType.PAUSE_POINT_CLOUD;
        } else if (equals(type, KMLConstants.TEXT_ACTION_CONTINUE_POINT_CLOUD)) {
            return WaypointActionType.CONTINUE_POINT_CLOUD;
        } else if (equals(type, KMLConstants.TEXT_ACTION_FINISH_POINT_CLOUD)) {
            return WaypointActionType.FINISH_POINT_CLOUD;
        } else if (equals(type, KMLConstants.TEXT_ACTION_CAMERA_MKDIR)) {
            return WaypointActionType.CAMERA_MKDIR;
        } else {
            return null;
        }
    }

    /**
     * Default return Waypoint Type
     */
    public static MissionType getMissionType(String type) {
        if (equals(type, KMLConstants.MISSION_TYPE_MAPPING_2D)) {
            return MissionType.Mapping2D;
        } else if (equals(type, KMLConstants.MISSION_TYPE_MAPPING_3D)) {
            return MissionType.Mapping3D;
        } else if (equals(type, KMLConstants.MISSION_TYPE_WAYPOINT)) {
            return MissionType.Waypoint;
        } else if (equals(type, KMLConstants.MISSION_TYPE_STRIP)) {
            return MissionType.Strip;
        } else {
            return null;
        }
    }

    /**
     * Default return Clockwise
     */
    public static PointTurnMode getWaypointTurnMode(String turnMode) {
        if (equals(turnMode, KMLConstants.TURN_MODE_AUTO)) {
            return PointTurnMode.AUTO;
        } else if (equals(turnMode, KMLConstants.TURN_MODE_COUNTERCLOCKWISE)) {
            return PointTurnMode.COUNTER_CLOCKWISE;
        } else {
            return PointTurnMode.CLOCKWISE;
        }
    }

    /**
     * Default return Go HOME
     */
    public static WaypointMissionFinishedAction getActionOnFinish(String action) {
        if (equals(action, KMLConstants.FINISHED_ACTION_HOVER)) {
            return WaypointMissionFinishedAction.NO_ACTION;
        } else if (equals(action, KMLConstants.FINISHED_ACTION_GO_FIRST_POINT)) {
            return WaypointMissionFinishedAction.GO_FIRST_WAYPOINT;
        } else if (equals(action, KMLConstants.FINISHED_ACTION_AUTO_LAND)) {
            return WaypointMissionFinishedAction.AUTO_LAND;
        } else {
            return WaypointMissionFinishedAction.GO_HOME;
        }
    }

    /**
     * Default return Auto
     */
    public static WaypointMissionHeadingMode getHeadingMode(String headingMode) {
        if (equals(headingMode, KMLConstants.CONTROLLED_BY_RC)) {
            return WaypointMissionHeadingMode.CONTROL_BY_REMOTE_CONTROLLER;
        } else if (equals(headingMode, KMLConstants.USE_POINT_SETTING)) {
            return WaypointMissionHeadingMode.USING_WAYPOINT_HEADING;
        } else if (equals(headingMode, KMLConstants.HEADING_TOWARDS_POI)) {
            return WaypointMissionHeadingMode.TOWARD_POINT_OF_INTEREST;
        } else if (equals(headingMode, KMLConstants.USING_INITIAL_DIRECTION)) {
            return WaypointMissionHeadingMode.USING_INITIAL_DIRECTION;
        } else {
            return WaypointMissionHeadingMode.AUTO;
        }
    }

    public static String convert(WaypointV2MissionTypes.WaypointV2FlightPathMode type) {
        if (type == WaypointV2MissionTypes.WaypointV2FlightPathMode.CURVATURE_CONTINUOUS_PASSED) {
            return KMLConstants.TEXT_WAYPOINT_TYPE_CURVATURE_PASSED;
        } else if (type == WaypointV2MissionTypes.WaypointV2FlightPathMode.GOTO_POINT_CURVE_AND_STOP) {
            return KMLConstants.TEXT_WAYPOINT_TYPE_CURVATURE_STOP;
        } else if (type == WaypointV2MissionTypes.WaypointV2FlightPathMode.COORDINATE_TURN) {
            return KMLConstants.TEXT_WAYPOINT_TYPE_COORDINATE_TURNING;
        } else if (type == WaypointV2MissionTypes.WaypointV2FlightPathMode.GOTO_FIRST_POINT_ALONG_STRAIGHT_LINE) {
            return KMLConstants.TEXT_WAYPOINT_TYPE_STRAIGHT_IN;
        } else if (type == WaypointV2MissionTypes.WaypointV2FlightPathMode.STRAIGHT_OUT) {
            return KMLConstants.TEXT_WAYPOINT_TYPE_STRAIGHT_OUT;
        } else {
            return KMLConstants.TEXT_WAYPOINT_TYPE_LINE_STOP;
        }
    }

    public static WaypointV2MissionTypes.WaypointV2FlightPathMode getWaypointType(String type) {
        if (equals(type, KMLConstants.TEXT_WAYPOINT_TYPE_CURVATURE_PASSED )) {
            return WaypointV2MissionTypes.WaypointV2FlightPathMode.CURVATURE_CONTINUOUS_PASSED;
        } else if (equals(type, KMLConstants.TEXT_WAYPOINT_TYPE_CURVATURE_STOP)) {
            return WaypointV2MissionTypes.WaypointV2FlightPathMode.GOTO_POINT_CURVE_AND_STOP;
        } else if (equals(type, KMLConstants.TEXT_WAYPOINT_TYPE_COORDINATE_TURNING)) {
            return WaypointV2MissionTypes.WaypointV2FlightPathMode.COORDINATE_TURN;
        } else if (equals(type, KMLConstants.TEXT_WAYPOINT_TYPE_STRAIGHT_IN)) {
            return WaypointV2MissionTypes.WaypointV2FlightPathMode.GOTO_FIRST_POINT_ALONG_STRAIGHT_LINE;
        } else if (equals(type, KMLConstants.TEXT_WAYPOINT_TYPE_STRAIGHT_OUT)) {
            return WaypointV2MissionTypes.WaypointV2FlightPathMode.STRAIGHT_OUT;
        } else {
            return WaypointV2MissionTypes.WaypointV2FlightPathMode.GOTO_POINT_STRAIGHT_LINE_AND_STOP;
        }
    }

    public static String convert(WaypointDroneType droneType) {
        if (droneType == WaypointDroneType.PM430) {
            return KMLConstants.TEXT_DRONE_TYPE_PM430;
        } else if (droneType == WaypointDroneType.PM431) {
            return KMLConstants.TEXT_DRONE_TYPE_PM431;
        } else if(droneType == WaypointDroneType.P4R){
            return KMLConstants.TEXT_DRONE_TYPE_P4R;
        } else {
            return KMLConstants.TEXT_DRONE_TYPE_COMMON;
        }
    }

    public static WaypointDroneType getDroneType(String droneType) {
        if (equals(droneType, KMLConstants.TEXT_DRONE_TYPE_PM430)) {
            return WaypointDroneType.PM430;
        } else if (equals(droneType, KMLConstants.TEXT_DRONE_TYPE_PM431)) {
            return WaypointDroneType.PM431;
        } else if (equals(droneType, KMLConstants.TEXT_DRONE_TYPE_P4R)) {
            return WaypointDroneType.P4R;
        } else {
            return WaypointDroneType.COMMON;
        }
    }

    /**
     * Default return true (Enable GimbalPitchRotation)
     */
    public static boolean getGimbalPitchMode(String gimbalMode) {
        return equals(gimbalMode, KMLConstants.USE_POINT_SETTING);
    }

    public static int string2Int(String num) throws NumberFormatException {
        return Integer.parseInt(num);
    }

    public static double string2Double(String num) throws NumberFormatException {
        return Double.parseDouble(num);
    }

    public static float string2Float(String num) throws NumberFormatException {
        return Float.parseFloat(num);
    }

    public static boolean equals(String s1, String s2) {
        return !TextUtils.isEmpty(s1) && !TextUtils.isEmpty(s2) && s1.toLowerCase().equals(s2.toLowerCase());
    }

    public static boolean isKnownCamera(String cameraType) {
        return MappingCameraType.contains(cameraType);
    }
}
