package com.dji.wpmzsdk.common.utils.kml;

import com.dji.wpmzsdk.common.utils.kml.converter.PilotWaypointTurnMode;
import com.dji.wpmzsdk.common.utils.kml.data.DroneInfoModel;
import com.dji.wpmzsdk.common.utils.kml.data.MissionType;
import com.dji.wpmzsdk.common.utils.kml.mission.MissionCreateType;
import com.dji.wpmzsdk.common.utils.kml.mission.MissionInfoModel;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionFinishedAction;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionGotoWaypointMode;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionHeadingMode;
import com.dji.wpmzsdk.common.utils.kml.model.MissionInfoExtModel;
import com.dji.wpmzsdk.common.utils.kml.model.PointTurnMode;
import com.dji.wpmzsdk.common.utils.kml.model.WaylineModel;
import com.dji.wpmzsdk.common.utils.kml.model.WaypointDroneType;
import com.dji.wpmzsdk.common.utils.kml.model.WaypointMissionModel;
import com.dji.wpmzsdk.common.utils.kml.model.WaypointModel;

import java.util.ArrayList;
import java.util.UUID;

import dji.sdk.wpmz.value.mission.WaylineExitOnRCLostAction;

/**
 * @author feel.feng
 * @time 2023/06/30 2:30 下午
 * @description:
 */
public class SettingUtils {
    private static final String TAG = "SettingUtils";
    public static final float DEF_WAYLINE_SPEED = 5;
    // 在线任务录制 航线速度为15m/s
    public static final float DEF_WAYLINE_SPEED_ADD_POINT = 15;
    public static final float DEF_WAYLINE_HEIGHT = 100;
    public static final float DEF_WAYPOINT_SPEED = -1;
    public static final float MIN_WAYPOINT_HEIGHT = -10000;
    public static final float MAX_WAYPOINT_HEIGHT = 10000;
    public static final float MIN_WAYPOINT_RELATIVE_HEIGHT = -1500;
    public static final float MAX_WAYPOINT_RELATIVE_HEIGHT = 1500;
    public static final float DEF_WAYPOINT_RADIUS = 0.2F;
    public static final float DEF_SECURE_TAKEOFF_HEIGHT = 20F;
    public static final float MIN_SECURE_TAKEOFF_HEIGHT = 2F;


    public static WaypointMissionModel createWaypointMissionModel(String name) {
        WaypointMissionModel mission = new WaypointMissionModel();
        mission.setMissionInfo(createMissionInfoModel(name));
        mission.setWayline(createWaylineModel());
        mission.setWaypoints(new ArrayList<>());
        return mission;
    }

    public static MissionInfoModel createMissionInfoModel(String name) {
        MissionInfoModel model = new MissionInfoModel();
        model.setId(0L);
        model.setName(name);
        model.setType(MissionType.Waypoint);
        model.setCreateTime(System.currentTimeMillis());
        model.setUpdateTime(System.currentTimeMillis());
        model.setCollected(false);
        model.setUuid(UUID.randomUUID().toString().replace("-", "_"));
        MissionInfoExtModel extInfo = new MissionInfoExtModel();
        extInfo.setCreateType(MissionCreateType.MAP);
        model.setExtInfo(extInfo);
        return model;
    }

    public static WaylineModel createWaylineModel() {
        WaylineModel model = new WaylineModel();
        model.setAltitude(DEF_WAYLINE_HEIGHT);
        model.setAutoFlightSpeed(DEF_WAYLINE_SPEED);
        model.setGotoFirstPointMode(WaypointMissionGotoWaypointMode.GotoWaypointSafely);
        model.setActionOnFinish(WaypointMissionFinishedAction.GO_HOME);
        model.setHeadingMode(WaypointMissionHeadingMode.AUTO);
        model.setLostAction(WaylineExitOnRCLostAction.GO_BACK);
        model.setGimbalPitchRotationEnable(false);
        model.setDroneInfo(createDroneInfoModel());
        model.setWaypointTurnMode(PilotWaypointTurnMode.POINT_STOP_STRAIGHT);
        model.setSecureTakeoffHeight(DEF_SECURE_TAKEOFF_HEIGHT);
        return model;
    }

    public static DroneInfoModel createDroneInfoModel() {
        DroneInfoModel model = new DroneInfoModel();
        model.setDroneType(WaypointDroneType.PM430);
        return model;
    }

    public static WaypointModel createWaypointModel() {
        WaypointModel waypointModel = new WaypointModel();
        waypointModel.setAltitude(DEF_WAYLINE_HEIGHT);
        waypointModel.setSpeed(DEF_WAYPOINT_SPEED);
        waypointModel.setUseWaylineAltitude(true);
        waypointModel.setUseWaylineSpeed(true);
        waypointModel.setHeading(0);
        waypointModel.setCornerRadius(DEF_WAYPOINT_RADIUS);
        waypointModel.setGimbalPitch(0);
        waypointModel.setTurnMode(PointTurnMode.AUTO);
        waypointModel.setActions(new ArrayList<>());
        waypointModel.setUseWaylineHeadMode(true);
        waypointModel.setUseWaylinePointType(true);
        return waypointModel;
    }
}
