package com.dji.wpmzsdk.common.utils.kml.data;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */

public enum MissionType {
    /**
     * 航点任务
     */
    Waypoint(0),
    /**
     * 建图航拍
     */
    Mapping2D(1),
    /**
     * 倾斜摄影
     */
    Mapping3D(2),
    /**
     * 航带飞行
     */
    Strip(3),

    UNKNOWN(4);


    private int value;

    MissionType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public boolean _equals(int value) {
        return this.value==value;
    }

    public static MissionType find(int value) {
        MissionType result = Waypoint;
        for (int i = 0; i < values().length; i++) {
            if (values()[i]._equals(value)) {
                result = values()[i];
                break;
            }
        }
        return result;
    }

}
