package com.dji.wpmzsdk.common.utils.kml.mission;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */



import com.dji.wpmzsdk.common.utils.kml.data.MissionType;
import com.dji.wpmzsdk.common.utils.kml.model.MissionInfoExtModel;

import java.util.Objects;



/**
 * <p>Description:</p>
 *
 * @author create at 2018/6/29 下午8:03 by daniel for dji-pilot
 * @version v1.0
 */
public class MissionInfoModel implements Cloneable {

    private Long id;
    private String uuid;
    private String name;
    private long createTime;
    private long updateTime;
    private MissionType type;
    private String diagram;
    private double latitude;
    private double longitude;
    private String locationDesc;
    private float distance;
    private float duration;
    private int pointCount;
    private float area;
    private float gsd;
    private float inclinedGsd;
    private boolean collected;
    /**
     * rtk 类型
     */
    private RTKReferenceStationSource rtkStation;
    /**
     * 扩展字段
     */
    private MissionInfoExtModel extInfo;

    private String localWPMZPath;

    public String getLocalWPMZPath() {
        return localWPMZPath;
    }

    public void setLocalWPMZPath(String localWPMZPath) {
        this.localWPMZPath = localWPMZPath;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public String getDiagram() {
        return diagram;
    }

    public void setDiagram(String diagram) {
        this.diagram = diagram;
    }

    public String getLocationDesc() {
        return locationDesc;
    }

    public void setLocationDesc(String locationDesc) {
        this.locationDesc = locationDesc;
    }

    public MissionType getType() {
        return type;
    }

    public void setType(MissionType type) {
        this.type = type;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public float getDistance() {
        return distance;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public float getDuration() {
        return duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public int getPointCount() {
        return pointCount;
    }

    public void setPointCount(int pointCount) {
        this.pointCount = pointCount;
    }

    public float getArea() {
        return area;
    }

    public void setArea(float area) {
        this.area = area;
    }

    public float getGsd() {
        return gsd;
    }

    public void setGsd(float gsd) {
        this.gsd = gsd;
    }

    public float getInclinedGsd() {
        return inclinedGsd;
    }

    public void setInclinedGsd(float inclinedGsd) {
        this.inclinedGsd = inclinedGsd;
    }

    public boolean isCollected() {
        return collected;
    }

    public void setCollected(boolean collected) {
        this.collected = collected;
    }

    public RTKReferenceStationSource getRtkStation() {
        return rtkStation;
    }
    public void setRtkStation(RTKReferenceStationSource rtkStation) {
        this.rtkStation = rtkStation;
    }

    public MissionInfoExtModel getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(MissionInfoExtModel extInfo) {
        this.extInfo = extInfo;
    }

    @Override
    public MissionInfoModel clone() {
        MissionInfoModel model = null;
        try {
            model = (MissionInfoModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return model;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MissionInfoModel that = (MissionInfoModel) o;

        if (createTime != that.createTime) return false;
        if (updateTime != that.updateTime) return false;
        if (Double.compare(that.latitude, latitude) != 0) return false;
        if (Double.compare(that.longitude, longitude) != 0) return false;
        if (Float.compare(that.distance, distance) != 0) return false;
        if (Float.compare(that.duration, duration) != 0) return false;
        if (collected != that.collected) return false;
        if (rtkStation != that.rtkStation) return false;
        if (!Objects.equals(extInfo, that.extInfo)) return false;
        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (uuid != null ? !uuid.equals(that.uuid) : that.uuid != null) return false;
        if (name != null ? !name.equals(that.name) : that.name != null) return false;
        if (type != that.type) return false;
        if (diagram != null ? !diagram.equals(that.diagram) : that.diagram != null) return false;
        return locationDesc != null ? locationDesc.equals(that.locationDesc) : that.locationDesc == null;
    }

    @Override
    public int hashCode() {
        int result;
        long temp;
        result = id != null ? id.hashCode() : 0;
        result = 31 * result + (uuid != null ? uuid.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (int) (createTime ^ (createTime >>> 32));
        result = 31 * result + (int) (updateTime ^ (updateTime >>> 32));
        result = 31 * result + (type != null ? type.hashCode() : 0);
        result = 31 * result + (diagram != null ? diagram.hashCode() : 0);
        temp = Double.doubleToLongBits(latitude);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(longitude);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        result = 31 * result + (locationDesc != null ? locationDesc.hashCode() : 0);
        result = 31 * result + (distance != +0.0f ? Float.floatToIntBits(distance) : 0);
        result = 31 * result + (duration != +0.0f ? Float.floatToIntBits(duration) : 0);
        result = 31 * result + (collected ? 1 : 0);
        result = 31 * result + (rtkStation!=null ? rtkStation.hashCode() : 0);
        result = 31 * result + (extInfo != null ? extInfo.hashCode() : 0);
        return result;
    }

    /**
     * 生成任务执行时的MissionId，为了避免碰撞，这两个字段基本上能用来唯一标志一个任务了
     * 虽然SDK中MissionID是int，但飞控中只有两个字节，上传的时候会被截短，所以这里使用short
     * {@link MissionInfoEntity#getExecutingMissionId()}
     */
    public short getExecuteMissionId() {
        return (short) (name + updateTime).hashCode();
    }
}
