package com.dji.wpmzsdk.common.utils.kml.mission;

public enum WaypointMissionFlightPathMode {
    /**
     * The flight path will be normal and the aircraft will move from one waypoint to the next in straight lines.
     */
    NORMAL (0x00),
    /**
     * The flight path will be curved and the aircraft will move from one waypoint to the next in a curved motion, adhering to the `cornerRadiusInMeters`, which is set in `Waypoint`.
     */
    CURVED (0x01),
    /**
     * Unknown
     */
    UNKNOWN (0xFFFF);

    private int value;

    private static final WaypointMissionFlightPathMode[] allValues = values();

    WaypointMissionFlightPathMode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public boolean equals(int b) {
        return value == b;
    }

    public static WaypointMissionFlightPathMode find(int value) {
        WaypointMissionFlightPathMode result = null;
        for (int i = 0; i < allValues.length; i++) {
            if (allValues[i].equals(value)) {
                result = allValues[i];
                break;
            }
        }

        if(null == result){
            result = WaypointMissionFlightPathMode.UNKNOWN;
            result.value = value;
        }

        return result;
    }
}