package com.dji.wpmzsdk.common.utils.kml.mission;

public class WaypointV2MissionTypes {

    //Doc key: DJIWaypointV2_DJIWaypointV2FlightPathMode
    /**
     *  Waypoint flight path mode.
     */
    public enum WaypointV2FlightPathMode {

        //Doc key: DJIWaypointV2_DJIWaypointV2FlightPathMode_GoToPointAlongACurve
        /**
         *  In the mission, the aircraft will go to the waypoint along a curve and fly past
         *  the waypoint.
         */
        CURVATURE_CONTINUOUS_PASSED(0),

        //Doc key: DJIWaypointV2_DJIWaypointV2FlightPathMode_GoToPointAlongACurveAndStop
        /**
         *  In the mission, the aircraft will go to the waypoint along a curve and stop at
         *  the waypoint.
         */
        GOTO_POINT_CURVE_AND_STOP(1),

        //Doc key: DJIWaypointV2_DJIWaypointV2FlightPathMode_GoToPointInAStraightLineAndStop
        /**
         *  In the mission, the aircraft will go to the waypoint along a straight line and
         *  stop at the waypoint.
         */
        GOTO_POINT_STRAIGHT_LINE_AND_STOP(2),

        //Doc key: DJIWaypointV2_DJIWaypointV2FlightPathMode_CoordinateTurn
        /**
         *  In the mission, the aircraft will fly from the previous waypoint to the next
         *  waypoint along a smooth curve  without stopping at this waypoint. the next in a
         *  curved motion, adhering to the `getDampingDistance`,  which is set in
         *  `WaypointV2`.
         */
        COORDINATE_TURN(3),

        //Doc key: DJIWaypointV2_DJIWaypointV2FlightPathMode_GoToFirstPointAlongAStraightLine
        /**
         *  In the mission, the aircraft will go to the first waypoint along a straight
         *  line. This is only valid for the first waypoint.
         */
        GOTO_FIRST_POINT_ALONG_STRAIGHT_LINE(4),

        //Doc key: DJIWaypointV2_DJIWaypointV2FlightPathMode_StraightOut
        /**
         *  Straight exit the Last waypoint, Only valid for last waypoint.
         */
        STRAIGHT_OUT(5),

        //Doc key: DJIWaypointV2_DJIWaypointV2FlightPathMode_Unknown
        /**
         *  Unknown.
         */
        UNKNOWN(0xFF);

        private int value;

        WaypointV2FlightPathMode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean _equals(int b) {
            return value == b;
        }

        public static WaypointV2FlightPathMode find(int value) {
            WaypointV2FlightPathMode result = UNKNOWN;
            for (int i = 0; i < values().length; i++) {
                if (values()[i]._equals(value)) {
                    result = values()[i];
                    break;
                }
            }
            return result;
        }

    }

    //Doc key: DJIWaypointV2Mission_DJIWaypointV2MissionFinishedAction
    /**
     *  Actions will be taken when the waypoint mission is finished.
     */
    public enum MissionFinishedAction {

        //Doc key: DJIWaypointV2Mission_DJIWaypointV2MissionFinishedAction_NoAction
        /**
         *  No further action will be taken. The aircraft can be controlled by the remote
         *  controller.
         */
        NO_ACTION(0),

        //Doc key: DJIWaypointV2Mission_DJIWaypointV2MissionFinishedAction_GoHome
        /**
         *  Goes home when the mission is finished. The aircraft will land directly if it is
         *  within 20  meters away from the home point.
         */
        GO_HOME(1),

        //Doc key: DJIWaypointV2Mission_DJIWaypointV2MissionFinishedAction_AutoLanding
        /**
         *  The aircraft will land automatically at the last waypoint.
         */
        AUTO_LAND(2),

        //Doc key: DJIWaypointV2Mission_DJIWaypointV2MissionFinishedAction_GoToFirstWaypoint
        /**
         *  The aircraft will go back to the first waypoint and hover.
         */
        GO_FIRST_WAYPOINT(3),

        //Doc key: DJIWaypointV2Mission_DJIWaypointV2MissionFinishedAction_ContinueUntilStop
        /**
         *  When the aircraft reaches its final waypoint, it will hover without ending the
         *  mission. The joystick  can still be used to pull the aircraft back along its
         *  previous waypoints. The only way this mission  can end is if stopMission is
         *  called.
         */
        CONTINUE_UNTIL_STOP(4);

        private int value;

        MissionFinishedAction(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean _equals(int b) {
            return value == b;
        }

        public static MissionFinishedAction find(int value) {
            MissionFinishedAction result = NO_ACTION;
            for (int i = 0; i < values().length; i++) {
                if (values()[i]._equals(value)) {
                    result = values()[i];
                    break;
                }
            }
            return result;
        }

    }

    //Doc key: DJIWaypointV2MissionGotoFirstWaypointMode
    /**
     *  Possible flight mode to executes the mission.
     */
    public enum MissionGotoWaypointMode {

        //Doc key: DJIWaypointV2MissionGotoFirstWaypointMode_Safely
        /**
         *  Go to the waypoint safely. The aircraft will rise to the same altitude of the
         *  waypoint if the current  altitude is lower then the waypoint altitude. It then
         *  goes to the waypoint coordinate from the current  altitude, and proceeds to the
         *  altitude of the waypoint.
         */
        SAFELY(0),

        //Doc key: DJIWaypointV2MissionGotoFirstWaypointMode_PointToPoint
        /**
         *  Go to the waypoint from the current aircraft point to the waypoint directly.
         */
        POINT_TO_POINT(1);

        private int value;

        MissionGotoWaypointMode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean _equals(int b) {
            return value == b;
        }

        public static MissionGotoWaypointMode find(int value) {
            MissionGotoWaypointMode result = SAFELY;
            for (int i = 0; i < values().length; i++) {
                if (values()[i]._equals(value)) {
                    result = values()[i];
                    break;
                }
            }
            return result;
        }

    }

    //Doc key: DJIWaypointV2_DJIWaypointV2TurnMode
    /**
     *  The direction when the aircraft changes its heading to adapt to the heading at
     *  the waypoint.
     */
    public enum WaypointV2TurnMode {

        //Doc key: DJIWaypointV2_DJIWaypointV2TurnMode_Clockwise
        /**
         *  The aircraft's heading rotates clockwise.
         */
        CLOCKWISE(0),

        //Doc key: DJIWaypointV2_DJIWaypointV2TurnMode_CounterClockwise
        /**
         *  The aircraft's heading rotates counterclockwise.
         */
        COUNTER_CLOCKWISE(1),

        //Doc key: DJIWaypointV2_DJIWaypointV2TurnMode_Unknown
        /**
         *  Changes the heading of the aircraft by rotating the aircraft anti-clockwise.
         */
        UNKNOWN(0xff);

        private int value;

        WaypointV2TurnMode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean _equals(int b) {
            return value == b;
        }

        public static WaypointV2TurnMode find(int value) {
            WaypointV2TurnMode result = CLOCKWISE;
            for (int i = 0; i < values().length; i++) {
                if (values()[i]._equals(value)) {
                    result = values()[i];
                    break;
                }
            }
            return result;
        }

    }

    //Doc key: DJIWaypointV2_DJIWaypointV2HeadingMode
    /**
     *  Represents current aircraft's heading mode on current waypoint.
     */
    public enum WaypointV2HeadingMode {

        //Doc key: DJIWaypointV2_DJIWaypointV2HeadingMode_Auto
        /**
         *  Aircraft's heading will always be in the direction of flight.
         */
        AUTO(0),

        //Doc key: DJIWaypointV2_DJIWaypointV2HeadingMode_Fixed
        /**
         *  Aircraft's heading will be set to the heading when reaching the first waypoint.
         *  Before reaching the  first waypoint, the aircraft's heading can be controlled by
         *  the remote controller. When the aircraft  reaches the first waypoint, its
         *  heading will be fixed.
         */
        FIXED(1),

        //Doc key: DJIWaypointV2_DJIWaypointV2HeadingMode_Manual
        /**
         *  The aircraft's heading in the mission can be controlled by the remote
         *  controller.
         */
        MANUAL(2),

        //Doc key: DJIWaypointV2_DJIWaypointV2HeadingMode_WaypointCustom
        /**
         *  In the mission, the aircraft's heading will change dynamically and adapt to the
         *  heading set at the next waypoint.  See `getHeading` to preset the heading.
         */
        WAYPOINT_CUSTOM(3),

        //Doc key: DJIWaypointV2_DJIWaypointV2HeadingMode_TowardPointOfInterest
        /**
         *  Aircraft's heading will always toward point of interest. Using
         *  `getPointOfInterest` setting point of interest coordiate and
         *  `getPointOfInterestAltitude`  setting point of interset altitute.
         */
        TOWARD_POINT_OF_INTEREST(4),

        //Doc key: DJIWaypointV2_DJIWaypointV2HeadingMode_GimbalYawFollow
        /**
         *  The aircraft's heading rotates simultaneously with its gimbal's yaw.
         */
        GIMBAL_YAW_FOLLOW(5),

        //Doc key: DJIWaypointV2_DJIWaypointV2HeadingMode_Unknown
        /**
         *  Unknown.
         */
        UNKNOWN(0xFF);

        private int value;

        WaypointV2HeadingMode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean _equals(int b) {
            return value == b;
        }

        public static WaypointV2HeadingMode find(int value) {
            WaypointV2HeadingMode result = UNKNOWN;
            for (int i = 0; i < values().length; i++) {
                if (values()[i]._equals(value)) {
                    result = values()[i];
                    break;
                }
            }
            return result;
        }
    }


}
