package com.dji.wpmzsdk.common.utils.kml.model;

import dji.sdk.wpmz.jni.JNIProguardKeepTag;

public enum CameraType implements JNIProguardKeepTag {
    /**
     *  X3
     */
    DJICameraTypeFC350 (0),
    /**
     *  X5
     */
    DJICameraTypeFC550 (1),
    /**
     *  P3S
     */
    DJICameraTypeFC260 (2),
    /**
     *  P3A
     */
    DJICameraTypeFC300S (3),
    /**
     *  P3P
     */
    DJICameraTypeFC300X (4),
    /**
     *  X5R
     */
    DJICameraTypeFC550Raw (5),
    /**
     *  P4
     */
    DJICameraTypeFC330X (6),
    /**
     *  XT 640
     */
    DJICameraTypeTau640 (7),
    /**
     *  DJICameraTypeTau336  XT 336
     */
    ZENMUSE_XT (8),
    /**
     *  Mavic Pro
     */
    DJICameraTypeFC220 (9),
    /**
     *  P3X WIFI
     */
    DJICameraTypeFC300XW (10),
    /**
     *  Z3
     */
    DJICameraTypeCV600 (11),
    /**
     *  In2 sensor未监测到相机
     */
    DJICameraTypeFC65XXUnknown (12),
    /**
     *  P4A and P4Pro
     */
    DJICameraTypeFC6310 (13),
    ZENMUSE_X4s (14),
    ZENMUSE_X5s (15),
    /**
     *  msdk 定义是 x9
     */
    ZENMUSE_X7 (16),
    /**
     *  X7
     */
    DJICameraTypeFC6540 (17),
    /**
     *  Mavic (low-end camera)
     */
    DJICameraTypeFC220S (18),
    /**
     *  Spark
     */
    DJICameraTypeFC1102 (19),
    ZENMUSE_X30 (20),
    /**
     *  P4A IMX183相机
     */
    DJICameraTypeFC6310A (21),
    /**
     *  P3C魔改版，P3SE
     */
    DJICameraTypeP3SE (22),
    MAVIC_AIR (23),
    /**
     *  OSMO MINI 小相机
     */
    FC300X_HG200 (24),
    /**
     *  ZOOM相机
     */
    MAVIC_2_ZOOM (25),
    /**
     *  xt2相机
     */
    ZENMUSE_XT2 (26),
    /**
     *  HG330相机
     */
    DJICameraTypeHG330 (27),
    /**
     *  p4 pro
     */
    P4P_V2_CAMERA (28),
    /**
     *  哈苏相机 Mavic 2 Pro
     */
    MAVIC_2_PRO (29),
    /**
     * 第三方相机
     */
    Payload (31),
    /**
     *  运动相机
     */
    AC101 (33),
    /**
     *  P4M 多光谱相机
     */
    DJICameraTypeFC336 (37),
    /**
     *  wm245IMX477相机
     */
    DJICameraTypeFC245_IMX477 (38),
    /**
     * PM420 FPV相机
     */
    M200_V2_Camera (39),
    /**
     *  wm245双光相机
     */
    DJICameraTypeFC2403 (40),
    /**
     *  xts相机
     */
    ZENMUSE_XTS (41),
    /**
     *  GD610双光相机
     */
    DJICameraTypeGD610DualLight (42),
    /**
     *  GD610三光相机
     */
    DJICameraTypeGD610TripleLight (43),
    /**
     * WM160
     */
    MAVIC_MINI (44),
    /**
     * WM231
     */
    MAVIC_AIR_2 (45),
    /**
     *  WM170 IMX577 相机
     */
    WM170_GLASS (46),
    /**
     *  HG211 相机
     */
    OSMO_POCKET_2 (47),
    /**
     *  AC201相机
     */
    AC201 (48),
    /**
     *  WM161 IMX378 相机
     */
    MAVIC_MINI_2 (49),
    /**
     *  EP600 IMX366相机
     */
    ZENMUSE_L1 (50),
    /**
     *  WM232 IMX283相机
     */
    MAVIC_AIR_2S (51),
    /**
     *  PM320 双光相机（一路广角IMX586，一路高倍变焦IMX586）
     */
    DJICameraTypePM320DualLight (52),
    /**
     *  PM320 三光相机（一路广角IMX586，一路高倍变焦IMX586，一路自研红外）
     */
    DJICameraTypePM320TripleLight (53),
    /**
     *  WM260 IMX272+IMX586 相机（接力变焦）
     */
    WM260 (54),
    /**
     *  WM1605
     */
    MAVIC_MINI_SE (56),
    /**
     *  Osmo Action 2 哈苏版本相机
     */
    OSMO_ACTION_2_HASSELBLAD (57),
    /**
     *  Osmo Action 2 小相机
     */
    OSMO_ACTION_2 (62),
    WM169 (58),
    WM162 (60),
    /**
     * GD612相机
     */
    GD612 (61),
    WM630 (63),
    /**
     *  WM265E IMX272+IMX586相机
     */
    WM265_E (66),
    /**
     *  WM265T 三光相机（一路广角IMX586，一路长焦IMX586，一路红外）
     */
    WM265_T (67),
    /**
     *  WM265M 多光谱相机
     */
    WM265_M (68),
    AC202 (69),
    HG212 (70),
    /**
     *  TA101 FPV相机
     */
    TA101 (71),
    /**
     *  哈苏相机
     */
    DJICameraTypeHasselH6D50C (0xA6),
    /**
     *  哈苏相机
     */
    DJICameraTypeHasselH6D100C (0xA7),
    /**
     * Unknown
     */
    UNKNOWN (0xFFFF);

    private int value;

    private static final CameraType[] allValues = values();

    CameraType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public boolean equals(int b) {
        return value == b;
    }

    public static CameraType find(int value) {
        CameraType result = null;
        for (int i = 0; i < allValues.length; i++) {
            if (allValues[i].equals(value)) {
                result = allValues[i];
                break;
            }
        }

        if(null == result){
            result = CameraType.UNKNOWN;
            result.value = value;
        }

        return result;
    }
}
