package com.dji.wpmzsdk.common.utils.kml.model;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import dji.sdk.wpmz.value.mission.CameraLensType;


/**
 * Description :
 *
 * @author : devin.xu
 * @filename : DroneCameraModel
 * @time : 2019-09-10
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class DroneCameraModel implements Cloneable {

    private int cameraIndex;

    private int cameraType;

    private String cameraName;

    private int payloadCameraType;

    private PayloadInfoModel payloadInfo;

    private PayloadConfigInfoModel payloadConfigInfo;

    private Set<CameraLensType> photoTypes;

    public int getCameraIndex() {
        return cameraIndex;
    }

    public void setCameraIndex(int cameraIndex) {
        this.cameraIndex = cameraIndex;
    }

    public int getCameraType() {
        return cameraType;
    }

    public void setCameraType(int cameraType) {
        this.cameraType = cameraType;
    }

    public String getCameraName() {
        if (payloadInfo != null && payloadInfo.getName() != null) {
            return payloadInfo.getName();
        }

        return cameraName;
    }

    public void setCameraName(String cameraName) {
        this.cameraName = cameraName;
    }

    public PayloadInfoModel getPayloadInfo() {
        return payloadInfo;
    }

    public void setPayloadInfo(PayloadInfoModel payloadInfo) {
        this.payloadInfo = payloadInfo;
    }

    public int getPayloadCameraType() {
        return payloadCameraType;
    }

    public void setPayloadCameraType(int payloadCameraType) {
        this.payloadCameraType = payloadCameraType;
    }

    public PayloadConfigInfoModel getPayloadConfigInfo() {
        return payloadConfigInfo;
    }

    public void setPayloadConfigInfo(PayloadConfigInfoModel payloadConfigInfo) {
        this.payloadConfigInfo = payloadConfigInfo;
    }

    public boolean isEP800Camera() {
        return payloadCameraType == PayloadCameraType.EP800.value();
    }

    public boolean isPSDKCamera() {
        return cameraType == CameraType.Payload.value() && payloadCameraType == PayloadCameraType.UNKNOWN.value();
    }

    public Set<CameraLensType> getPhotoTypes() {
        return photoTypes;
    }

    public void setPhotoTypes(Set<CameraLensType> photoTypes) {
        this.photoTypes = photoTypes;
    }

    @Override
    public DroneCameraModel clone() {
        DroneCameraModel model = null;
        try {
            model = (DroneCameraModel) super.clone();
            if (payloadConfigInfo != null) {
                model.payloadConfigInfo = payloadConfigInfo.clone();
            }
            if (photoTypes != null) {
                model.photoTypes = new HashSet<>(photoTypes);
            }
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return model;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DroneCameraModel that = (DroneCameraModel) o;
        return cameraIndex == that.cameraIndex &&
                cameraType == that.cameraType &&
                payloadCameraType == that.payloadCameraType &&
                Objects.equals(cameraName, that.cameraName) &&
                Objects.equals(payloadConfigInfo, that.payloadConfigInfo) &&
                Objects.equals(photoTypes, that.photoTypes);

    }

    @Override
    public int hashCode() {
        return Objects.hash(cameraIndex, cameraType, cameraName, payloadCameraType, payloadConfigInfo, photoTypes);
    }
}
