package com.dji.wpmzsdk.common.utils.kml.model;

import java.util.Objects;

/**
 * Description :
 *
 * @author : devin.xu
 * @filename : DroneHeightModel
 * @time : 2019-10-23
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class DroneHeightModel implements Cloneable {

    private boolean useAbsolute;

    private boolean hasTakeoffHeight;

    private float takeoffHeight;

    private double takeoffLat;

    private double takeoffLng;

    // 相对对面高模式
    private boolean aboveGroundMode;

    public boolean isUseAbsolute() {
        return useAbsolute;
    }

    public void setUseAbsolute(boolean useAbsolute) {
        this.useAbsolute = useAbsolute;
    }

    public boolean isHasTakeoffHeight() {
        return hasTakeoffHeight;
    }

    public void setHasTakeoffHeight(boolean hasTakeoffHeight) {
        this.hasTakeoffHeight = hasTakeoffHeight;
    }

    public float getTakeoffHeight() {
        return takeoffHeight;
    }

    public void setTakeoffHeight(float takeoffHeight) {
        this.takeoffHeight = takeoffHeight;
    }

    public double getTakeoffLat() {
        return takeoffLat;
    }

    public void setTakeoffLat(double takeoffLat) {
        this.takeoffLat = takeoffLat;
    }

    public double getTakeoffLng() {
        return takeoffLng;
    }

    public void setTakeoffLng(double takeoffLng) {
        this.takeoffLng = takeoffLng;
    }

    public boolean isAboveGroundMode() {
        return aboveGroundMode;
    }

    public void setAboveGroundMode(boolean aboveGroundMode) {
        this.aboveGroundMode = aboveGroundMode;
    }

    @Override
    public DroneHeightModel clone() {
        try {
            return (DroneHeightModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return null;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DroneHeightModel that = (DroneHeightModel) o;
        return useAbsolute == that.useAbsolute
                && hasTakeoffHeight == that.hasTakeoffHeight
                && Float.compare(that.takeoffHeight, takeoffHeight) == 0
                && Double.compare(that.takeoffLat, takeoffLat) == 0
                && Double.compare(that.takeoffLng, takeoffLng) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(useAbsolute, hasTakeoffHeight, takeoffHeight, takeoffLat, takeoffLng);
    }
}
