package com.dji.wpmzsdk.common.utils.kml.model;
/*
 * Copyright (c) 2014, DJI All Rights Reserved.
 */

/**
 * <p>Created by luca on 2017/1/23.</p>
 */

public class Location2D {

    public static final float ACCURACY_GPS_FINE = 16.0F;

    /**
     * 约0.4M
     */
    public static final double GPS_CHANGED = 0.000001;

    /**
     * The location latitude.
     */
    public double latitude;

    /**
     * The location longitude.
     */
    public double longitude;

    public float accuracy;

    public Location2D(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public float getAccuracy() {
        return accuracy;
    }

    public void setAccuracy(float accuracy) {
        this.accuracy = accuracy;
    }

    public boolean isChanged(double lat, double lng) {
        return Math.abs(latitude - lat) >= GPS_CHANGED || Math.abs(longitude - lng) >= GPS_CHANGED;
    }

    public boolean isAvailable() {
        return isAvailable(this.latitude, this.longitude);
    }

    public boolean isFineAccuracy() {
        return this.isFineAccuracy(16.0F);
    }

    public boolean isFineAccuracy(float meters) {
        return isFineAccuracy(this.accuracy, meters);
    }

    public static boolean isFineAccuracy(float accuracy, float meter) {
        return 0.0F < accuracy && accuracy <= meter;
    }

    public boolean _equals(Location2D latLng) {
        return latLng != null && (latLng.latitude == this.latitude && latLng.longitude == this.longitude);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        } else if (obj == null || !(obj instanceof Location2D)) {
            return false;
        } else {
            Location2D obj1 = (Location2D) obj;
            return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(obj1.latitude)
                && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(obj1.longitude);
        }
    }

    @Override
    public String toString() {
        return this.latitude + "," + this.longitude;
    }

    public static Location2D valueOf(String string) {
        String[] s = string.split(",");
        return s.length != 2?null:new Location2D(Double.valueOf(s[0]), Double.valueOf(s[1]));
    }

    /**
     * 实测发现飞机刚获取GPS信号时坐标值有可能在 1E-8 ~ 1E-7 之间
     */
    public static boolean isAvailable(double latitude, double longitude) {
        return Math.abs(latitude) > 1.0E-7D
                && Math.abs(longitude) > 1.0E-7D
                && Math.abs(latitude) <= 90.0D
                && Math.abs(longitude) <= 180.0D;
    }
}
