package com.dji.wpmzsdk.common.utils.kml.model;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */

import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionFinishedAction;

import java.util.List;


import dji.sdk.wpmz.value.mission.WaylineExitOnRCLostAction;
import dji.sdk.wpmz.value.mission.WaylineMappingPitchMode;
import dji.sdk.wpmz.value.mission.WaylineMappingYawMode;

/**
 * <p>Description:</p>
 *
 * @author create at 2018/12/21 16:10 by davis.qiao for dji-pilot
 * @version v1.0
 */

public class Mapping2DWaylineModel implements Cloneable {
    
    private Long id;
    private int direction;
    private float altitude;
    private float wgs84Altitude;
    private float takeoffSpeed;
    private float speed;
    private float margin;
    private int overlapH;
    private int overlapW;
    private WaypointMissionFinishedAction actionOnFinish;
    private WaylineExitOnRCLostAction lostAction;
    private MappingCameraModel camera;
    private boolean elevationOptimize;
    private int photoMode;
    private int photoFormat;
    private int focusMode;
    private boolean enableDewarping;
    private boolean fiveWayPose;
    private int fiveWayPoseWithGimbalPitch;
    // lidar
    private int echoMode;
    private int sampleRate; // 这里存的是Index 要实际转化
    private int scanMode;
    private boolean needVariegation;

    private boolean enableDsm;
    private float dsmAltitude;
    private List<String> dsmPath;
    private boolean realtimeSurfaceFollow;
    // abs
    private int altitudeMode;
    private float relativeDistance;
    // ep800 cali
    private boolean enableCalibrate;
    // S 参考点
    private LocationCoordinate3D takeOffPositionRef;
    private float secureTakeoffHeight;

    private boolean yawParamEnable = false;
    private WaylineMappingYawMode yawParamMode;
    private float yawParamAngle;
    private WaylineMappingPitchMode yawParamGimbalPitchMode;
    private float yawParamGimbalPitchAngle;
    // 倾斜爬升开关
    private boolean mappingInclineClimbEnable;

    public int getFiveWayPoseWithGimbalPitch() {
        return fiveWayPoseWithGimbalPitch;
    }

    public void setFiveWayPoseWithGimbalPitch(int fiveWayPoseWithGimbalPitch) {
        this.fiveWayPoseWithGimbalPitch = fiveWayPoseWithGimbalPitch;
    }

    public boolean isFiveWayPose() {
        return fiveWayPose;
    }

    public void setFiveWayPose(boolean fiveWayPose) {
        this.fiveWayPose = fiveWayPose;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getDirection() {
        return direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public float getAltitude() {
        return altitude;
    }

    public void setAltitude(float alt) {
        this.altitude = alt;
    }

    public float getSpeed() {
        return speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getTakeoffSpeed() {
        return takeoffSpeed;
    }

    public void setTakeoffSpeed(float takeoffSpeed) {
        this.takeoffSpeed = takeoffSpeed;
    }

    public float getMargin() {
        return margin;
    }

    public void setMargin(float margin) {
        this.margin = margin;
    }

    public int getOverlapH() {
        return overlapH;
    }

    public void setOverlapH(int overlapH) {
        this.overlapH = overlapH;
    }

    public int getOverlapW() {
        return this.overlapW;
    }

    public void setOverlapW(int overlapW) {
        this.overlapW = overlapW;
    }

    public WaypointMissionFinishedAction getActionOnFinish() {
        return actionOnFinish;
    }

    public void setActionOnFinish(WaypointMissionFinishedAction actionOnFinish) {
        this.actionOnFinish = actionOnFinish;
    }

    public MappingCameraModel getCamera() {
        return camera;
    }

    public void setCamera(MappingCameraModel camera) {
        this.camera = camera;
    }

    public boolean isElevationOptimize() {
        return elevationOptimize;
    }

    public void setElevationOptimize(boolean elevationOptimize) {
        this.elevationOptimize = elevationOptimize;
    }

    public int getPhotoMode() {
        return photoMode;
    }
    public void setPhotoMode(int photoMode) {
        this.photoMode = photoMode;
    }

    public int getPhotoFormat() {
        return photoFormat;
    }

    public void setPhotoFormat(int photoFormat) {
        this.photoFormat = photoFormat;
    }

    public boolean isEnableDewarping() {
        return enableDewarping;
    }

    public void setEnableDewarping(boolean enableDewarping) {
        this.enableDewarping = enableDewarping;
    }

    public boolean isEnableDsm() {
        return enableDsm;
    }

    public void setEnableDsm(boolean enableDsm) {
        this.enableDsm = enableDsm;
    }

    public float getDsmAltitude() {
        return dsmAltitude;
    }

    public void setDsmAltitude(float dsmAltitude) {
        this.dsmAltitude = dsmAltitude;
    }

    public List<String> getDsmPath() {
        return dsmPath;
    }

    public void setDsmPath(List<String> dsmPath) {
        this.dsmPath = dsmPath;
    }

    public int getAltitudeMode() {
        return altitudeMode;
    }

    public void setAltitudeMode(int altitudeMode) {
        this.altitudeMode = altitudeMode;
    }

    public float getRelativeDistance() {
        return relativeDistance;
    }

    public void setRelativeDistance(float distance) {
        this.relativeDistance = distance;
    }

    public int getFocusMode() {
        return focusMode;
    }

    public void setFocusMode(int focusMode) {
        this.focusMode = focusMode;
    }

    public int getEchoMode() {
        return echoMode;
    }

    public void setEchoMode(int echoMode) {
        this.echoMode = echoMode;
    }

    public int getSampleRate() {
        return sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getScanMode() {
        return scanMode;
    }

    public void setScanMode(int scanMode) {
        this.scanMode = scanMode;
    }

    public boolean isNeedVariegation() {
        return needVariegation;
    }

    public void setNeedVariegation(boolean needVariegation) {
        this.needVariegation = needVariegation;
    }

    public boolean isEnableCalibrate() {
        return enableCalibrate;
    }

    public void setEnableCalibrate(boolean enableCalibrate) {
        this.enableCalibrate = enableCalibrate;
    }

    public WaylineExitOnRCLostAction getLostAction() {
        return lostAction;
    }

    public void setLostAction(WaylineExitOnRCLostAction lostAction) {
        this.lostAction = lostAction;
    }

    public float getWgs84Altitude() {
        return wgs84Altitude;
    }

    public void setWgs84Altitude(float wgs84Altitude) {
        this.wgs84Altitude = wgs84Altitude;
    }

    public LocationCoordinate3D getTakeOffPositionRef() {
        return takeOffPositionRef;
    }

    public void setTakeOffPositionRef(LocationCoordinate3D takeOffPositionRef) {
        this.takeOffPositionRef = takeOffPositionRef;
    }

    public boolean isRealtimeSurfaceFollow() {
        return realtimeSurfaceFollow;
    }

    public void setRealtimeSurfaceFollow(boolean realtimeSurfaceFollow) {
        this.realtimeSurfaceFollow = realtimeSurfaceFollow;
    }

    public float getSecureTakeoffHeight() {
        return secureTakeoffHeight;
    }

    public void setSecureTakeoffHeight(float secureTakeoffHeight) {
        this.secureTakeoffHeight = secureTakeoffHeight;
    }

    public boolean isYawParamEnable() {
        return yawParamEnable;
    }

    public void setYawParamEnable(boolean yawParamEnable) {
        this.yawParamEnable = yawParamEnable;
    }

    public WaylineMappingYawMode getYawParamMode() {
        return yawParamMode;
    }

    public void setYawParamMode(WaylineMappingYawMode yawParamMode) {
        this.yawParamMode = yawParamMode;
    }

    public float getYawParamAngle() {
        return yawParamAngle;
    }

    public void setYawParamAngle(float yawParamAngle) {
        this.yawParamAngle = yawParamAngle;
    }

    public WaylineMappingPitchMode getYawParamGimbalPitchMode() {
        return yawParamGimbalPitchMode;
    }

    public void setYawParamGimbalPitchMode(WaylineMappingPitchMode yawParamGimbalPitchMode) {
        this.yawParamGimbalPitchMode = yawParamGimbalPitchMode;
    }

    public float getYawParamGimbalPitchAngle() {
        return yawParamGimbalPitchAngle;
    }

    public void setYawParamGimbalPitchAngle(float yawParamGimbalPitchAngle) {
        this.yawParamGimbalPitchAngle = yawParamGimbalPitchAngle;
    }

    public boolean isMappingInclineClimbEnable() {
        return mappingInclineClimbEnable;
    }

    public void setMappingInclineClimbEnable(boolean mappingInclineClimbEnable) {
        this.mappingInclineClimbEnable = mappingInclineClimbEnable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Mapping2DWaylineModel model = (Mapping2DWaylineModel) o;

        if (direction != model.direction) return false;
        if (altitude != model.altitude) return false;
        if (Float.compare(model.speed, speed) != 0) return false;
        if (Float.compare(model.takeoffSpeed, takeoffSpeed) != 0) return false;
        if (Float.compare(model.margin, margin) != 0) return false;
        if (overlapH != model.overlapH) return false;
        if (overlapW != model.overlapW) return false;
        if (id != null ? !id.equals(model.id) : model.id != null) return false;
        if (actionOnFinish != model.actionOnFinish) return false;
        if (elevationOptimize != model.elevationOptimize) return false;
        if (fiveWayPose != model.fiveWayPose) return false;
        if (photoMode != model.photoMode) return false;
        if (photoFormat != model.photoFormat) return false;
        if (focusMode != model.focusMode) return false;
        if (enableDewarping != model.enableDewarping) return false;
        if (enableDsm != model.enableDsm) return false;
        if (camera != null ? !camera.equals(model.camera) : model.camera != null) return false;
        if (dsmAltitude != model.dsmAltitude) return false;
        if (fiveWayPoseWithGimbalPitch != model.fiveWayPoseWithGimbalPitch) return false;
        if (altitudeMode != model.altitudeMode) return false;
        if (relativeDistance != model.relativeDistance) return false;
        if (echoMode != model.echoMode) return false;
        if (sampleRate != model.sampleRate) return false;
        if (scanMode != model.scanMode) return false;
        if (needVariegation != model.needVariegation) return false;
        if (enableCalibrate != model.enableCalibrate) return false;
        if (mappingInclineClimbEnable != model.mappingInclineClimbEnable) return false;
        if (Float.compare(model.secureTakeoffHeight, secureTakeoffHeight) != 0) return false;
        return dsmPath != null ? dsmPath.equals(model.dsmPath) : model.dsmPath == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + direction;
        result = 31 * result + (altitude != +0.0f ? Float.floatToIntBits(altitude) : 0);
        result = 31 * result + (speed != +0.0f ? Float.floatToIntBits(speed) : 0);
        result = 31 * result + (takeoffSpeed != +0.0f ? Float.floatToIntBits(takeoffSpeed) : 0);
        result = 31 * result + (margin != +0.0f ? Float.floatToIntBits(margin) : 0);
        result = 31 * result + overlapH;
        result = 31 * result + overlapW;
        result = 31 * result + (actionOnFinish != null ? actionOnFinish.hashCode() : 0);
        result = 31 * result + (camera != null ? camera.hashCode() : 0);
        result = 31 * result + (elevationOptimize ? 1 : 0);
        result = 31 * result + photoMode;
        result = 31 * result + photoFormat;
        result = 31 * result + focusMode;
        result = 31 * result + (enableDewarping ? 1 : 0);
        result = 31 * result + (fiveWayPose ? 1 : 0);
        result = 31 * result + (enableDsm ? 1 : 0);
        result = 31 * result + (dsmPath != null ? dsmPath.hashCode() : 0);
        result = 31 * result + (dsmAltitude != +0.0f ? Float.floatToIntBits(dsmAltitude) : 0);
        result = 31 * result + fiveWayPoseWithGimbalPitch;
        result = 31 * result + altitudeMode;
        result = 31 * result + (relativeDistance != +0.0f ? Float.floatToIntBits(relativeDistance) : 0);;
        result = 31 * result + echoMode;
        result = 31 * result + sampleRate;
        result = 31 * result + scanMode;
        result = 31 * result + (needVariegation ? 1 : 0);
        result = 31 * result + (enableCalibrate ? 1 : 0);
        result = 31 * result + (mappingInclineClimbEnable ? 1 : 0);
        result = 31 * result + (secureTakeoffHeight != +0.0f ? Float.floatToIntBits(secureTakeoffHeight) : 0);
        return result;
    }


    @Override
    public Mapping2DWaylineModel clone() {
        Mapping2DWaylineModel model;
        try {
            model = (Mapping2DWaylineModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        if (camera != null) {
            model.setCamera(camera.clone());
        }
        if (dsmPath != null) {
            model.setDsmPath(dsmPath);
        }
        return model;
    }

    public Mapping2DWaylineModel() {
    }

}
