package com.dji.wpmzsdk.common.utils.kml.model;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */

import android.os.Parcel;

/**
 * <p>Description:</p>
 *
 * @author create at 2019/1/10 18:29 by davis.qiao for dji-pilot
 * @version v1.0
 */

public class MappingCameraModel implements Cloneable {

    private Long id;
    private String name;
    private float focalLength;
    private float sensorWidth;
    private float sensorHeight;
    private int imageWidth;
    private int imageHeight;
    private float shotInterval;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getFocalLength() {
        return focalLength;
    }

    public void setFocalLength(float focalLength) {
        this.focalLength = focalLength;
    }

    public float getSensorWidth() {
        return sensorWidth;
    }

    public void setSensorWidth(float sensorWidth) {
        this.sensorWidth = sensorWidth;
    }

    public float getSensorHeight() {
        return sensorHeight;
    }

    public void setSensorHeight(float sensorHeight) {
        this.sensorHeight = sensorHeight;
    }

    public int getImageWidth() {
        return imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public float getShotInterval() {
        return shotInterval;
    }

    public void setShotInterval(float shotInterval) {
        this.shotInterval = shotInterval;
    }

    public void updateValue(MappingCameraModel model) {
        this.id = model.id;
        this.name = model.name;
        this.focalLength = model.focalLength;
        this.sensorHeight = model.sensorHeight;
        this.sensorWidth = model.sensorWidth;
        this.imageHeight = model.imageHeight;
        this.imageWidth = model.imageWidth;
        this.shotInterval = model.shotInterval;
    }

    /**
     * 比较除 ID 外的其他字段
     * @param that
     * @return
     */
    public boolean valueEquals(MappingCameraModel that) {
        if (that == null) return false;
        if (Float.compare(that.focalLength, focalLength) != 0) return false;
        if (Float.compare(that.sensorWidth, sensorWidth) != 0) return false;
        if (Float.compare(that.sensorHeight, sensorHeight) != 0) return false;
        if (imageWidth != that.imageWidth) return false;
        if (imageHeight != that.imageHeight) return false;
        if (Float.compare(that.shotInterval, shotInterval) != 0) return false;
        return name != null ? name.equals(that.name) : that.name == null;
    }

    @Override
    public MappingCameraModel clone() {
        MappingCameraModel model;
        try {
            model = (MappingCameraModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
            model = null;
        }
        return model;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MappingCameraModel that = (MappingCameraModel) o;

        if (Float.compare(that.focalLength, focalLength) != 0) return false;
        if (Float.compare(that.sensorWidth, sensorWidth) != 0) return false;
        if (Float.compare(that.sensorHeight, sensorHeight) != 0) return false;
        if (imageWidth != that.imageWidth) return false;
        if (imageHeight != that.imageHeight) return false;
        if (Float.compare(that.shotInterval, shotInterval) != 0) return false;
        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        return name != null ? name.equals(that.name) : that.name == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (focalLength != +0.0f ? Float.floatToIntBits(focalLength) : 0);
        result = 31 * result + (sensorWidth != +0.0f ? Float.floatToIntBits(sensorWidth) : 0);
        result = 31 * result + (sensorHeight != +0.0f ? Float.floatToIntBits(sensorHeight) : 0);
        result = 31 * result + imageWidth;
        result = 31 * result + imageHeight;
        result = 31 * result + (shotInterval != +0.0f ? Float.floatToIntBits(shotInterval) : 0);
        return result;
    }

    public MappingCameraModel() {
    }

    protected MappingCameraModel(Parcel in) {
        this.id = (Long) in.readValue(Long.class.getClassLoader());
        this.name = in.readString();
        this.focalLength = in.readFloat();
        this.sensorWidth = in.readFloat();
        this.sensorHeight = in.readFloat();
        this.imageWidth = in.readInt();
        this.imageHeight = in.readInt();
        this.shotInterval = in.readFloat();
    }

}
