package com.dji.wpmzsdk.common.utils.kml.model;

import java.util.Objects;



/**
 * Create date: 2020/10/15
 *
 * @author bryan.jia
 * <p>
 * Description:
 */
public class PayloadConfigInfoModel implements Cloneable {

    public static final int ECHO_MODE_SINGLE_FIRST = 0;
    public static final int ECHO_MODE_SINGLE_STRONG = 1;
    public static final int ECHO_MODE_DOUBLE = 2;
    public static final int ECHO_MODE_TREBLE = 3;

    public static final int METERING_MODE_GLOBAL = 0;
    public static final int METERING_MODE_POINT = 1;

    /**
     * 测光模式 ｛平均；点｝
     */
    private int meteringMode;
    /**
     * 畸变校正
     */
    private boolean enableDewarp;
    /**
     * 回波模式
     */
    private int echoMode;
    /**
     * 采样频率
     */
    private int sampleRate;
    /**
     * 扫描模式
     */
    private int scanMode = ScanMode.REPEAT.value();
    /**
     * 模型上色
     */
    private boolean needVariegation;

    public int getMeteringMode() {
        return meteringMode;
    }

    public void setMeteringMode(int meteringMode) {
        this.meteringMode = meteringMode;
    }

    public boolean isEnableDewarp() {
        return enableDewarp;
    }

    public void setEnableDewarp(boolean enableDewarp) {
        this.enableDewarp = enableDewarp;
    }

    public int getEchoMode() {
        return echoMode;
    }

    public void setEchoMode(int echoMode) {
        this.echoMode = echoMode;
    }

    public int getSampleRate() {
        return sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getScanMode() {
        return scanMode;
    }

    public void setScanMode(int scanMode) {
        this.scanMode = scanMode;
    }

    public boolean isNeedVariegation() {
        return needVariegation;
    }

    public void setNeedVariegation(boolean needVariegation) {
        this.needVariegation = needVariegation;
    }

    @Override
    protected PayloadConfigInfoModel clone() {
        try {
            return (PayloadConfigInfoModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PayloadConfigInfoModel that = (PayloadConfigInfoModel) o;
        return meteringMode == that.meteringMode &&
                enableDewarp == that.enableDewarp &&
                echoMode == that.echoMode &&
                sampleRate == that.sampleRate &&
                scanMode == that.scanMode &&
                needVariegation == that.needVariegation;
    }

    @Override
    public int hashCode() {
        return Objects.hash(meteringMode, enableDewarp, echoMode, sampleRate, scanMode, needVariegation);
    }

    @Override
    public String toString() {
        return "PayloadConfigInfoModel{" +
                "meteringMode=" + meteringMode +
                ", enableDewarp=" + enableDewarp +
                ", echoMode=" + echoMode +
                ", sampleRate=" + sampleRate +
                ", scanMode=" + scanMode +
                ", needVariegation=" + needVariegation +
                '}';
    }
}
