package com.dji.wpmzsdk.common.utils.kml.model;

/**
 * Description :
 * 精准拍照信息
 *
 * @author : devin.xu
 * @filename : PreciseShotInfo
 * @time : 2019-10-15
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class PreciseShotInfo {

    private int imageWidth;

    private int imageHeight;

    private float cropPosX;

    private float cropPosY;

    private float cropWidth;

    private float cropHeight;

    private float cropAngle;

    private double focalDistance;

    private int afPosition;

    private float gimbalPitch;

    private float gimbalRoll;

    private float gimbalYaw;

    private int cameraType;

    private int cameraIndex;

    private int gimbalPort;

    private long fileSize;

    private String cacheFilePath;

    private String cacheFileName;

    private float droneYaw;

    private int fileIndex;

    private String fileMD5;

    private String uuid;

    private Integer apertureSize;

    private Double shutterSpeed;

    private Integer isoParam;

    private Integer exposureCompensation;

    private Integer luminance;

    private Integer objectFocusDistance;

    private PhotoMode photoMode;

    public PreciseShotInfo() {
    }
    public float getDroneYaw() {
        return droneYaw;
    }

    public void setDroneYaw(float droneYaw) {
        this.droneYaw = droneYaw;
    }

    public String getCacheFilePath() {
        return cacheFilePath;
    }

    public void setCacheFilePath(String cacheFilePath) {
        this.cacheFilePath = cacheFilePath;
    }

    public String getCacheFileName() {
        return cacheFileName;
    }

    public void setCacheFileName(String cacheFileName) {
        this.cacheFileName = cacheFileName;
    }

    public int getImageWidth() {
        return imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public float getCropPosX() {
        return cropPosX;
    }

    public void setCropPosX(float cropPosX) {
        this.cropPosX = cropPosX;
    }

    public float getCropPosY() {
        return cropPosY;
    }

    public void setCropPosY(float cropPosY) {
        this.cropPosY = cropPosY;
    }

    public float getCropWidth() {
        return cropWidth;
    }

    public void setCropWidth(float cropWidth) {
        this.cropWidth = cropWidth;
    }

    public float getCropHeight() {
        return cropHeight;
    }

    public void setCropHeight(float cropHeight) {
        this.cropHeight = cropHeight;
    }

    public double getFocalDistance() {
        return focalDistance;
    }

    public void setFocalDistance(double focalDistance) {
        this.focalDistance = focalDistance;
    }

    public int getAfPosition() {
        return afPosition;
    }

    public void setAfPosition(int afPosition) {
        this.afPosition = afPosition;
    }

    public float getGimbalPitch() {
        return gimbalPitch;
    }

    public void setGimbalPitch(float gimbalPitch) {
        this.gimbalPitch = gimbalPitch;
    }

    public float getGimbalRoll() {
        return gimbalRoll;
    }

    public void setGimbalRoll(float gimbalRoll) {
        this.gimbalRoll = gimbalRoll;
    }

    public float getGimbalYaw() {
        return gimbalYaw;
    }

    public void setGimbalYaw(float gimbalYaw) {
        this.gimbalYaw = gimbalYaw;
    }

    public int getCameraType() {
        return cameraType;
    }

    public void setCameraType(int cameraType) {
        this.cameraType = cameraType;
    }

    public int getGimbalPort() {
        return gimbalPort;
    }

    public void setGimbalPort(int gimbalPort) {
        this.gimbalPort = gimbalPort;
    }

    public long getFileSize() {
        return fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public int getCameraIndex() {
        return cameraIndex;
    }

    public void setCameraIndex(int cameraIndex) {
        this.cameraIndex = cameraIndex;
    }

    public float getCropAngle() {
        return cropAngle;
    }

    public void setCropAngle(float cropAngle) {
        this.cropAngle = cropAngle;
    }

    public int getFileIndex() {
        return fileIndex;
    }

    public void setFileIndex(int fileIndex) {
        this.fileIndex = fileIndex;
    }

    public String getFileMD5() {
        return fileMD5;
    }

    public void setFileMD5(String fileMD5) {
        this.fileMD5 = fileMD5;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Integer getApertureSize() {
        return apertureSize;
    }

    public void setApertureSize(Integer apertureSize) {
        this.apertureSize = apertureSize;
    }

    public Double getShutterSpeed() {
        return shutterSpeed;
    }

    public void setShutterSpeed(Double shutterSpeed) {
        this.shutterSpeed = shutterSpeed;
    }

    public Integer getIsoParam() {
        return isoParam;
    }

    public void setIsoParam(Integer isoParam) {
        this.isoParam = isoParam;
    }

    public Integer getExposureCompensation() {
        return exposureCompensation;
    }

    public void setExposureCompensation(Integer exposureCompensation) {
        this.exposureCompensation = exposureCompensation;
    }

    public Integer getLuminance() {
        return luminance;
    }

    public void setLuminance(Integer luminance) {
        this.luminance = luminance;
    }

    public Integer getObjectFocusDistance() {
        return objectFocusDistance;
    }

    public void setObjectFocusDistance(Integer objectFocusDistance) {
        this.objectFocusDistance = objectFocusDistance;
    }

    public PhotoMode getPhotoMode() {
        return photoMode;
    }

    public void setPhotoMode(PhotoMode photoMode) {
        this.photoMode = photoMode;
    }

    public boolean isFrameValid() {
        return cropWidth > 0 && cropHeight > 0;
    }

    public enum PhotoMode {

        NORMAL,

        LOW_LIGHT_SMART
    }
}
