package com.dji.wpmzsdk.common.utils.kml.model;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */

/**
 * @author create at 2020/06/10 by otto.ouyang for dji-pilot
 */

public class StripEdgePointModel implements Cloneable {

    private Long id;
    private double latitude;
    private double longitude;
    private int index;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        StripEdgePointModel that = (StripEdgePointModel) o;

        if (Double.compare(that.latitude, latitude) != 0) return false;
        if (Double.compare(that.longitude, longitude) != 0) return false;
        if (index != that.index) return false;
        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        int result;
        long temp;
        result = id != null ? id.hashCode() : 0;
        temp = Double.doubleToLongBits(latitude);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(longitude);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        result = 31 * result + index;
        return result;
    }

    @Override
    public StripEdgePointModel clone() {
        StripEdgePointModel model;
        try {
            model = (StripEdgePointModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
            model = null;
        }
        return model;
    }


    public StripEdgePointModel() {
    }

    public StripEdgePointModel(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

}
