package com.dji.wpmzsdk.common.utils.kml.model;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */



import com.dji.wpmzsdk.common.utils.kml.CollectionUtil;
import com.dji.wpmzsdk.common.utils.kml.DroneTypeUtils;
import com.dji.wpmzsdk.common.utils.kml.converter.PilotWaypointTurnMode;
import com.dji.wpmzsdk.common.utils.kml.data.DroneInfoModel;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionFinishedAction;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionGotoWaypointMode;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionHeadingMode;

import java.util.List;
import java.util.Objects;


import dji.sdk.wpmz.value.mission.WaylineExitOnRCLostAction;


/**
 * <p>Description:</p>
 *
 * @author create at 2018/7/2 下午10:08 by daniel for dji-pilot
 * @version v1.0
 */
public class WaylineModel implements Cloneable {
    private Long id;
    private float altitude;

    private float autoFlightSpeed;
    private WaypointMissionGotoWaypointMode gotoFirstPointMode;
    private WaypointMissionFinishedAction actionOnFinish;
    private WaypointMissionHeadingMode headingMode;
    private double poiLatitude;
    private double poiLongitude;
    private boolean gimbalPitchRotationEnable;
    private PilotWaypointTurnMode waypointTurnMode;
    private DroneInfoModel droneInfo;
    private boolean flightCali;
    private WaylineExitOnRCLostAction lostAction;
    private float secureTakeoffHeight;
    private List<WaypointActionModel> actions;

    public boolean isAdvanceWayLine() {
        return droneInfo != null && (DroneTypeUtils.isPM430OrPM431(droneInfo.getDroneType())
                || DroneTypeUtils.isPM320(droneInfo.getDroneType())
                || DroneTypeUtils.isWM265(droneInfo.getDroneType()));
    }

    public DroneInfoModel getDroneInfo() {
        return droneInfo;
    }

    public void setDroneInfo(DroneInfoModel droneInfo) {
        this.droneInfo = droneInfo;
    }

    public PilotWaypointTurnMode getWaypointTurnMode() {
        return waypointTurnMode;
    }

    public void setWaypointTurnMode(PilotWaypointTurnMode waypointTurnMode) {
        this.waypointTurnMode = waypointTurnMode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public float getAltitude() {
        return altitude;
    }

    public void setAltitude(float altitude) {
        this.altitude = altitude;
    }

    public float getAutoFlightSpeed() {
        return autoFlightSpeed;
    }

    public void setAutoFlightSpeed(float autoFlightSpeed) {
        this.autoFlightSpeed = autoFlightSpeed;
    }

    public WaypointMissionGotoWaypointMode getGotoFirstPointMode() {
        return gotoFirstPointMode;
    }

    public void setGotoFirstPointMode(WaypointMissionGotoWaypointMode gotoFirstPointMode) {
        this.gotoFirstPointMode = gotoFirstPointMode;
    }

    public WaypointMissionFinishedAction getActionOnFinish() {
        return actionOnFinish;
    }

    public void setActionOnFinish(WaypointMissionFinishedAction actionOnFinish) {
        this.actionOnFinish = actionOnFinish;
    }

    public WaypointMissionHeadingMode getHeadingMode() {
        return headingMode;
    }

    public void setHeadingMode(WaypointMissionHeadingMode headingMode) {
        this.headingMode = headingMode;
    }

    public double getPoiLatitude() {
        return poiLatitude;
    }

    public void setPoiLatitude(double poiLatitude) {
        this.poiLatitude = poiLatitude;
    }

    public double getPoiLongitude() {
        return poiLongitude;
    }

    public void setPoiLongitude(double poiLongitude) {
        this.poiLongitude = poiLongitude;
    }


    public boolean isGimbalPitchRotationEnable() {
        return gimbalPitchRotationEnable;
    }

    public void setGimbalPitchRotationEnable(boolean gimbalPitchRotationEnable) {
        this.gimbalPitchRotationEnable = gimbalPitchRotationEnable;
    }

    public boolean isFlightCali() {
        return flightCali;
    }

    public void setFlightCali(boolean flightCali) {
        this.flightCali = flightCali;
    }

    public WaylineExitOnRCLostAction getLostAction() {
        return lostAction;
    }

    public void setLostAction(WaylineExitOnRCLostAction lostAction) {
        this.lostAction = lostAction;
    }

    public float getSecureTakeoffHeight() {
        return secureTakeoffHeight;
    }

    public void setSecureTakeoffHeight(float secureTakeoffHeight) {
        this.secureTakeoffHeight = secureTakeoffHeight;
    }

    public List<WaypointActionModel> getActions() {
        return actions;
    }

    public void setActions(List<WaypointActionModel> actions) {
        this.actions = actions;
    }

    @Override
    public WaylineModel clone() {
        WaylineModel model = null;
        try {
            model = (WaylineModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        if (droneInfo != null) {
            model.setDroneInfo(droneInfo.clone());
        }
        model.setActions(CollectionUtil.transform(actions, WaypointActionModel::clone));
        return model;
    }

    public WaylineModel() {
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WaylineModel that = (WaylineModel) o;
        return Float.compare(that.altitude, altitude) == 0 &&
                Float.compare(that.autoFlightSpeed, autoFlightSpeed) == 0 &&
                Double.compare(that.poiLatitude, poiLatitude) == 0 &&
                Double.compare(that.poiLongitude, poiLongitude) == 0 &&
                gimbalPitchRotationEnable == that.gimbalPitchRotationEnable &&
                Objects.equals(id, that.id) &&
                gotoFirstPointMode == that.gotoFirstPointMode &&
                actionOnFinish == that.actionOnFinish &&
                headingMode == that.headingMode &&
                waypointTurnMode == that.waypointTurnMode &&
                Objects.equals(actions, that.actions) &&
                Objects.equals(droneInfo, that.droneInfo) &&
                flightCali == that.flightCali &&
                secureTakeoffHeight == that.secureTakeoffHeight;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, altitude, autoFlightSpeed, gotoFirstPointMode,
                actionOnFinish, headingMode, poiLatitude, poiLongitude,
                gimbalPitchRotationEnable, waypointTurnMode, droneInfo, flightCali,
                secureTakeoffHeight, actions);
    }

}
