package com.dji.wpmzsdk.common.utils.kml.model;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */

import android.os.Parcel;

import java.util.Objects;
import java.util.Set;

import dji.sdk.wpmz.value.mission.ActionMegaphoneParam;
import dji.sdk.wpmz.value.mission.ActionSearchlightParam;
import dji.sdk.wpmz.value.mission.CameraLensType;

/**
 * <p>Description:</p>
 *
 * @author create at 2018/7/4 下午3:12 by daniel for dji-pilot
 * @version v1.0
 */
public class WaypointActionModel implements Cloneable {
    private Long id;

    private int index;

    private WaypointActionType actionType;

    /**
     * 悬停，单位 ms
     * 云台俯仰角，单位度
     * 云台偏航角，单位度
     * 相机变焦，单位 mm
     * 飞行器偏航角，单位度
     */
    private int param;

    private int accuracy;

    private int cameraIndex;

    private int payloadType;

    private int payloadIndex;

    private String mediaPathName;

    private boolean followPhotoType;

    private Set<CameraLensType> photoTypes;

    private PreciseShotInfo preciseShotInfo;

    private ActionMegaphoneParam megaphoneParam;

    private ActionSearchlightParam searchlightParam;

    public ActionMegaphoneParam getMegaphoneParam() {
        return megaphoneParam;
    }

    public void setMegaphoneParam(ActionMegaphoneParam megaphoneParam) {
        this.megaphoneParam = megaphoneParam;
    }

    public ActionSearchlightParam getSearchlightParam() {
        return searchlightParam;
    }

    public void setSearchlightParam(ActionSearchlightParam searchlightParam) {
        this.searchlightParam = searchlightParam;
    }

    public boolean isFollowPhotoType() {
        return followPhotoType;
    }

    public void setFollowPhotoType(boolean followPhotoType) {
        this.followPhotoType = followPhotoType;
    }

    public Set<CameraLensType> getPhotoTypes() {
        return photoTypes;
    }

    public void setPhotoTypes(Set<CameraLensType> photoTypes) {
        this.photoTypes = photoTypes;
    }

    public String getMediaPathName() {
        return mediaPathName;
    }

    public void setMediaPathName(String mediaPathName) {
        this.mediaPathName = mediaPathName;
    }

    public int getCameraIndex() {
        return cameraIndex;
    }

    public void setCameraIndex(int cameraIndex) {
        this.cameraIndex = cameraIndex;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public WaypointActionType getActionType() {
        return actionType;
    }

    public void setActionType(WaypointActionType actionType) {
        this.actionType = actionType;
    }

    public int getParam() {
        return param;
    }

    public void setParam(int param) {
        this.param = param;
    }

    public int getPayloadType() {
        return payloadType;
    }

    public void setPayloadType(int payloadType) {
        this.payloadType = payloadType;
    }

    public int getPayloadIndex() {
        return payloadIndex;
    }

    public void setPayloadIndex(int payloadIndex) {
        this.payloadIndex = payloadIndex;
    }

    public int getAccuracy() {
        return accuracy;
    }

    public void setAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }

    public float getRealParam() {
        if (accuracy != 0) {
            return (float) (param / Math.pow(10, accuracy));
        } else {
            return param;
        }
    }

    public boolean isPreciseShotAction() {
        return actionType == WaypointActionType.PRECISE_SHOT
                || actionType == WaypointActionType.NORMAL_PRECISE_SHOT
                || actionType == WaypointActionType.ORIENTED_SHOT;
    }

    public PreciseShotInfo getPreciseShotInfo() {
        return preciseShotInfo;
    }

    public void setPreciseShotInfo(PreciseShotInfo preciseShotInfo) {
        this.preciseShotInfo = preciseShotInfo;
    }

    @Override
    public WaypointActionModel clone() {
        WaypointActionModel model = null;
        try {
            model = (WaypointActionModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return model;
    }

    public WaypointActionModel() {
    }

    protected WaypointActionModel(Parcel in) {
        this.id = (Long) in.readValue(Long.class.getClassLoader());
        this.index = in.readInt();
        int tmpActionType = in.readInt();
        this.actionType = tmpActionType == -1 ? null : WaypointActionType.values()[tmpActionType];
        this.param = in.readInt();
        this.cameraIndex = in.readInt();
        this.payloadIndex = in.readInt();
        this.payloadType = in.readInt();
        this.accuracy = in.readInt();
        this.mediaPathName = in.readString();
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        WaypointActionModel that = (WaypointActionModel) o;

        if (index != that.index) return false;
        if (param != that.param) return false;
        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (cameraIndex != that.cameraIndex) return false;
        if (payloadIndex != that.payloadIndex) return false;
        if (payloadType != that.payloadType) return false;
        if (accuracy != that.accuracy) return false;
        if (!Objects.equals(mediaPathName, that.mediaPathName)) return false;
        return actionType == that.actionType;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + index;
        result = 31 * result + (actionType != null ? actionType.hashCode() : 0);
        result = 31 * result + param;
        result = 31 * result + cameraIndex;
        result = 31 * result + payloadIndex;
        result = 31 * result + payloadType;
        result = 31 * result + accuracy;
        result = 31 * result + (mediaPathName != null ? mediaPathName.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "WaypointActionModel{" +
                "id=" + id +
                ", index=" + index +
                ", actionType=" + actionType +
                ", param=" + param +
                ", accuracy=" + accuracy +
                ", cameraIndex=" + cameraIndex +
                ", payloadType=" + payloadType +
                ", payloadIndex=" + payloadIndex +
                ", mediaPathName='" + mediaPathName + '\'' +
                ", followPhotoType=" + followPhotoType +
                ", photoTypes=" + photoTypes +
                ", preciseShotInfo=" + preciseShotInfo +
                '}';
    }
}
