package com.dji.wpmzsdk.common.utils.kml.model;

/**
 * Description :
 *
 * @author : devin.xu
 * @filename : WaypointActionType
 * @time : 2019-08-27
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public enum WaypointActionType {

    /**
     * 悬停
     */
    STAY(0x00),

    /**
     * 拍照
     */
    START_TAKE_PHOTO(0x01),

    /**
     * 开始录像
     */
    START_RECORD(0x02),

    /**
     * 结束录像
     */
    STOP_RECORD(0x03),

    /**
     * 飞机转 yaw
     */
    ROTATE_AIRCRAFT(0x04),

    /**
     * 云台 pitch
     */
    GIMBAL_PITCH(0x05),

    /**
     * 云台 yaw
     */
    GIMBAL_YAW(0x06),

    /**
     * 变焦
     */
    CAMERA_ZOOM(0x07),

    /**
     * 对焦
     */
    CAMERA_FOCUS(0x08),

    /**
     * 等时拍
     */
    START_TIME_INTERVAL_SHOT(0x1001),

    /**
     * 等距拍
     */
    START_DISTANCE_INTERVAL_SHOT(0x1002),

    /**
     * 停止等时等距拍
     */
    STOP_INTERVAL_SHOT(0x1003),

    /**
     * 精准拍照
     */
    PRECISE_SHOT(0x1004),

    /**
     * 相机创建文件夹
     */
    CAMERA_MKDIR(0x1005),

    /**
     * 精准拍照未框选动作，示教动作
     */
    NORMAL_PRECISE_SHOT(0x1006),

    /**
     * 定向拍照
     */
    ORIENTED_SHOT(0x1007),

    /**
     * 全景拍照
     */
    PANO_SHOT(0x1008),

    /**
     * 喊话器动作
     */
    MEGAPHONE(0x1009),

    /**
     * 探照灯动作
     */
    SEARCHLIGHT(0x100B),

    /**
     * PSDK 执行动作
     */
    PAYLOAD_BUTTON(0x1101),

    /**
     * PSDK 开关
     */
    PAYLOAD_SWITCH_ON(0x1102),

    /**
     * PSDK 开关
     */
    PAYLOAD_SWITCH_OFF(0x1103),

    /**
     * PSDK 滑动值
     */
    PAYLOAD_SEEK_VALUE(0x1104),

    /**
     * 开始点云录制动作
     */
    START_POINT_CLOUD(0x1105),

    /**
     * 暂停录制点云模型动作
     */
    PAUSE_POINT_CLOUD(0x1106),

    /**
     * 继续录制点云模型动作
     */
    CONTINUE_POINT_CLOUD(0x1107),

    /**
     * 停止录制点云模型动作
     */
    FINISH_POINT_CLOUD(0x1108);

    private int value;

    WaypointActionType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }


    public boolean _equals(int b) {
        return value==b;
    }


    public static WaypointActionType find(int value) {
        WaypointActionType result = STAY;
        for (int i = 0; i < values().length; i++) {
            if (values()[i]._equals(value)) {
                result = values()[i];
                break;
            }
        }
        return result;
    }

    public static boolean isImageAction(WaypointActionType type) {
        return type == WaypointActionType.START_TAKE_PHOTO
                || type == WaypointActionType.PRECISE_SHOT
                || type == WaypointActionType.NORMAL_PRECISE_SHOT
                || type == WaypointActionType.ORIENTED_SHOT
                || type == WaypointActionType.PANO_SHOT;
    }

}
