package com.dji.wpmzsdk.common.utils.kml.model;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */



import com.dji.wpmzsdk.common.utils.kml.CollectionUtil;
import com.dji.wpmzsdk.common.utils.kml.converter.PilotWaypointTurnMode;
import com.dji.wpmzsdk.common.utils.kml.converter.PilotWaypointTurnModeKt;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionHeadingMode;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointV2MissionTypes;

import java.util.List;
import java.util.Objects;




/**
 * <p>Description:</p>
 *
 * @author create at 2018/7/4 下午2:45 by daniel for dji-pilot
 * @version v1.0
 */
public class WaypointModel implements Cloneable {

    private Long id;
    private double latitude;
    private double longitude;
    private float altitude;
    // 椭球高，绝对高下需要计算，相对高下和 altitude 一致
    private float wgs84Altitude;
    private int heading;
    private float cornerRadius;
    private float speed;
    private float gimbalPitch;
    private PointTurnMode turnMode;
    private List<WaypointActionModel> actions;
    private int index;
    // 默认是跟随航线
    private boolean useWaylineAltitude = true;
    private boolean useWaylineSpeed = true;
    private boolean useWaylineHeadMode;
    private boolean useWaylinePointType;
    private boolean useWaylineAction = false;
    @Deprecated
    private WaypointV2MissionTypes.WaypointV2FlightPathMode waypointType;
    private PilotWaypointTurnMode waypointTurnMode;
    private WaypointMissionHeadingMode headingMode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public float getAltitude() {
        return altitude;
    }

    public void setAltitude(float altitude) {
        this.altitude = altitude;
    }

    public void setUseWaylineAltitude(boolean useWaylineAltitude) {
        this.useWaylineAltitude = useWaylineAltitude;
    }

    public int getHeading() {
        return heading;
    }

    public void setHeading(int heading) {
        this.heading = heading;
    }

    public float getCornerRadius() {
        return cornerRadius;
    }

    public void setCornerRadius(float cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    public float getSpeed() {
        return speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getGimbalPitch() {
        return gimbalPitch;
    }

    public void setGimbalPitch(float gimbalPitch) {
        this.gimbalPitch = gimbalPitch;
    }

    public PointTurnMode getTurnMode() {
        return turnMode;
    }

    public void setTurnMode(PointTurnMode turnMode) {
        this.turnMode = turnMode;
    }

    public List<WaypointActionModel> getActions() {
        return actions;
    }

    public void setActions(List<WaypointActionModel> actions) {
        this.actions = actions;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isUseWaylineSpeed() {
        return useWaylineSpeed;
    }

    public void setUseWaylineSpeed(boolean useWaylineSpeed) {
        this.useWaylineSpeed = useWaylineSpeed;
    }

    public boolean isUseWaylineHeadMode() {
        return useWaylineHeadMode;
    }

    public void setUseWaylineHeadMode(boolean useWaylineHeadMode) {
        this.useWaylineHeadMode = useWaylineHeadMode;
    }

    public WaypointMissionHeadingMode getHeadingMode() {
        return headingMode;
    }

    public void setHeadingMode(WaypointMissionHeadingMode headingMode) {
        this.headingMode = headingMode;
    }


    public boolean isUseWaylinePointType() {
        return useWaylinePointType;
    }

    public void setUseWaylinePointType(boolean useWaylinePointType) {
        this.useWaylinePointType = useWaylinePointType;
    }

    public boolean isUseWaylineAction() {
        return useWaylineAction;
    }

    public void setUseWaylineAction(boolean useWaylineAction) {
        this.useWaylineAction = useWaylineAction;
    }

    public void setWaypointType(WaypointV2MissionTypes.WaypointV2FlightPathMode waypointType) {
        this.waypointType = waypointType;
        if (waypointType != null) {
            waypointTurnMode = PilotWaypointTurnModeKt.convert(waypointType);
        }
    }

    public PilotWaypointTurnMode getWaypointTurnMode() {
        return waypointTurnMode;
    }

    public void setWaypointTurnMode(PilotWaypointTurnMode waypointTurnMode) {
        this.waypointTurnMode = waypointTurnMode;
    }

    public float getWgs84Altitude() {
        return wgs84Altitude;
    }

    public void setWgs84Altitude(float wgs84Altitude) {
        this.wgs84Altitude = wgs84Altitude;
    }

    public boolean isUseWaylineAltitude() {
        return useWaylineAltitude;
    }

    public boolean hasPreciseShotAction() {
        if (actions == null || actions.isEmpty()) {
            return false;
        }

        for (WaypointActionModel actionItem : actions) {
            if (actionItem.isPreciseShotAction()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public WaypointModel clone() {
        WaypointModel model;
        try {
            model = (WaypointModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        model.setActions(CollectionUtil.transform(actions, WaypointActionModel::clone));
        return model;
    }



    public WaypointModel() {
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WaypointModel that = (WaypointModel) o;
        return Double.compare(that.latitude, latitude) == 0 &&
                Double.compare(that.longitude, longitude) == 0 &&
                Float.compare(that.altitude, altitude) == 0 &&
                heading == that.heading &&
                Float.compare(that.cornerRadius, cornerRadius) == 0 &&
                Float.compare(that.speed, speed) == 0 &&
                Float.compare(that.gimbalPitch, gimbalPitch) == 0 &&
                index == that.index &&
                useWaylineAltitude == that.useWaylineAltitude &&
                useWaylineSpeed == that.useWaylineSpeed &&
                useWaylineHeadMode == that.useWaylineHeadMode &&
                useWaylinePointType == that.useWaylinePointType &&
                Objects.equals(id, that.id) &&
                turnMode == that.turnMode &&
                Objects.equals(actions, that.actions) &&
                waypointTurnMode == that.waypointTurnMode &&
                useWaylineAction == that.useWaylineAction &&
                headingMode == that.headingMode;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, latitude, longitude, altitude, heading, cornerRadius,
                speed, gimbalPitch, turnMode,
                actions, index, useWaylineAltitude, useWaylineSpeed, useWaylineHeadMode,
                useWaylinePointType, waypointTurnMode, headingMode, useWaylineAction);
    }
}
