package com.dji.wpmzsdk.common.utils.kml.transfrom

import com.dji.industry.pilot.data.cache.model.MappingCameraModelGreenDao

import com.dji.wpmzsdk.common.utils.kml.model.MappingCameraModel
import com.dji.wpmzsdk.common.utils.kml.model.MappingCameraType
import kotlin.math.roundToInt
import kotlin.math.tan

/**
 * Create date: 2021/12/14
 * @author bryan.jia
 *
 * @Description:
 *
 */
private const val L1_LIDAR_FOV = 70.4
private const val L1_VISIBLE_FOV = 84.0

fun getLidarVisibleOverlapW(model: MappingCameraModel?, overlapW: Int): Int {
    return if (model != null && MappingCameraType.find(model.name) == MappingCameraType.EP800_LIDAR) {
        getVisibleOverlapWValue(overlapW)
    } else {
        overlapW
    }
}

/**
 * 已知雷达旁向重叠率，求可见光旁向重叠率
 * @param overlapW 雷达旁向重叠率
 */
fun getVisibleOverlapWValue(overlapW: Int): Int {
    val l = tan(Math.toRadians(L1_LIDAR_FOV / 2.0))
    val v = tan(Math.toRadians(L1_VISIBLE_FOV / 2.0))
    return (((v - l + overlapW / 100.0 * l) / v) * 100.0).roundToInt()
}

fun isLidarCamera(camera: MappingCameraModel?): Boolean {
    if (camera == null) {
        return false
    }
    val cameraType = MappingCameraType.find(camera.name)
    return cameraType == MappingCameraType.EP800_LIDAR
}

fun isLidarCamera(camera: MappingCameraModelGreenDao?): Boolean {
    if (camera == null) {
        return false
    }
    val cameraType = MappingCameraType.find(camera.name)
    return cameraType == MappingCameraType.EP800_LIDAR
}