package com.dji.wpmzsdk.common.utils.kml.transfrom;


import dji.sdk.wpmz.value.mission.WaylineTemplateShootType;

/**
 * Description :
 *
 * @author : devin.xu
 * @filename : MappingShootTypeTransform
 * @time : 2020/12/2
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class MappingShootTypeTransform implements ModelTransform<Integer, WaylineTemplateShootType> {

    private static final Integer SHOOT_TYPE_TIME = 0;
    private static final Integer SHOOT_TYPE_DISTANCE = 1;

    @Override
    public WaylineTemplateShootType transFrom(Integer integer) {
        if (SHOOT_TYPE_TIME.equals(integer)) {
            return WaylineTemplateShootType.TIME;
        } else {
            return WaylineTemplateShootType.DISTANCE;
        }
    }

    @Override
    public Integer transTo(WaylineTemplateShootType waylineTemplateShootType) {
        if (waylineTemplateShootType == WaylineTemplateShootType.TIME) {
            return SHOOT_TYPE_TIME;
        } else {
            return SHOOT_TYPE_DISTANCE;
        }
    }
}
