package com.dji.wpmzsdk.common.utils.kml.transfrom;



import com.dji.wpmzsdk.common.utils.kml.model.StripEdgePointModel;

import java.util.ArrayList;
import java.util.List;

import dji.sdk.wpmz.value.mission.WaylineLocationCoordinate3D;

/**
 * Description :
 *
 * @author : devin.xu
 * @filename : MappingEdgePointTransform
 * @time : 2020/12/2
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class StripEdgePointTransform implements ModelTransform<List<StripEdgePointModel>, List<WaylineLocationCoordinate3D>> {

    @Override
    public List<WaylineLocationCoordinate3D> transFrom(List<StripEdgePointModel> points) {
        List<WaylineLocationCoordinate3D> edgePoint = new ArrayList<>();
        for (StripEdgePointModel item : points) {
            WaylineLocationCoordinate3D location = new WaylineLocationCoordinate3D();
            location.setLatitude(item.getLatitude());
            location.setLongitude(item.getLongitude());
            edgePoint.add(location);
        }
        return edgePoint;
    }

    @Override
    public List<StripEdgePointModel> transTo(List<WaylineLocationCoordinate3D> points) {
        List<StripEdgePointModel> edgePointModels = new ArrayList<>();
        for (WaylineLocationCoordinate3D item : points) {
            StripEdgePointModel edgePoint = new StripEdgePointModel();
            edgePoint.setLatitude(item.getLatitude());
            edgePoint.setLongitude(item.getLongitude());
            edgePointModels.add(edgePoint);
        }
        return edgePointModels;
    }
}
