package com.dji.wpmzsdk.common.utils.kml.transfrom


import com.dji.wpmzsdk.common.utils.kml.mission.MissionInfoModel
import com.dji.wpmzsdk.common.utils.kml.model.MappingCameraType
import dji.sdk.wpmz.value.mission.*

/**
 * Description :
 *
 * @filename : WaylineExecuteConfigTransform
 * @author : devin.xu
 * @time : 2022/1/17
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
fun createExecuteConfig(config: WaylineMissionConfig): WaylineExecuteMissionConfig {
    val executeMissionConfig = WaylineExecuteMissionConfig()
    executeMissionConfig.droneInfo = config.droneInfo
    executeMissionConfig.exitOnRCLostBehavior = config.exitOnRCLostBehavior
    executeMissionConfig.finishAction = config.finishAction
    executeMissionConfig.exitOnRCLostType = config.exitOnRCLostType
    executeMissionConfig.flyToWaylineMode = config.flyToWaylineMode
    executeMissionConfig.globalRTHHeight = config.globalRTHHeight
    executeMissionConfig.isGlobalRTHHeightSet = config.isGlobalRTHHeightSet
    executeMissionConfig.globalTransitionalSpeed = config.globalTransitionalSpeed
    executeMissionConfig.isSecurityTakeOffHeightSet = config.isSecurityTakeOffHeightSet
    executeMissionConfig.payloadInfo = config.payloadInfo
    executeMissionConfig.securityTakeOffHeight = config.securityTakeOffHeight
    return executeMissionConfig
}

fun createWaylineMission(infoModel: MissionInfoModel): WaylineMission {
    val mission = WaylineMission()
    mission.updateTime = infoModel.updateTime.toDouble()
    mission.createTime = infoModel.createTime.toDouble()
    return mission
}

fun getDroneInfoFromCamera(cameraType: MappingCameraType?): WaylineDroneInfo {
    if (cameraType == null) return WaylineDroneInfo()
    val droneInfo = WaylineDroneInfo()
    when (cameraType) {
        MappingCameraType.PM320,
        MappingCameraType.PM320T_WIDE,
        MappingCameraType.PM320_IR,
        MappingCameraType.PM320_WIDE_IR -> droneInfo.droneType = WaylineDroneType.PM320
        MappingCameraType.WM265_WIDE,
        MappingCameraType.WM265_T_WIDE,
        MappingCameraType.WM265_IR,
        MappingCameraType.WM265_WIDE_IR,
        MappingCameraType.WM265_M_WIDE,
        MappingCameraType.WM265_M_NARROWBAND,
        MappingCameraType.WM265_M_WIDE_NARROWBAND -> droneInfo.droneType = WaylineDroneType.WM265
        MappingCameraType.P4 -> droneInfo.droneType = WaylineDroneType.Phantom4
        MappingCameraType.P4A -> droneInfo.droneType = WaylineDroneType.Phantom4Advanced
        MappingCameraType.P4P,
        MappingCameraType.P4PV2 -> droneInfo.droneType = WaylineDroneType.Phantom4Pro
        MappingCameraType.P4R -> droneInfo.droneType = WaylineDroneType.Phantom4RTK
        MappingCameraType.WM245_ZOOM,
        MappingCameraType.WM246 -> droneInfo.droneType = WaylineDroneType.UNKNOWN
        else -> droneInfo.droneType = WaylineDroneType.PM430
    }
    return droneInfo
}