package com.dji.wpmzsdk.common.utils.kml.transfrom



import com.dji.wpmzsdk.common.utils.kml.model.*

import dji.sdk.wpmz.value.mission.WaylineCustomPayloadActionInfo
import dji.sdk.wpmz.value.mission.WaylinePayloadInfo
import dji.sdk.wpmz.value.mission.WaylinePayloadType

/**
 * Description :
 *
 * @filename : WaylinePayloadInfoTransform
 * @author : devin.xu
 * @time : 2021/9/14
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
class WaylinePayloadInfoTransform : ModelTransform<DroneCameraModel, WaylinePayloadInfo> {

    override fun transFrom(droneCameraModel: DroneCameraModel): WaylinePayloadInfo {
        val payloadInfo = WaylinePayloadInfo()
        payloadInfo.payloadPositionIndex = droneCameraModel.cameraIndex
        payloadInfo.isPayloadPositionIndexSet = true
        payloadInfo.payloadType = transPayloadTypeFrom(droneCameraModel.cameraType, droneCameraModel.payloadCameraType)

        if (droneCameraModel.payloadInfo != null) {
            val payloadInfoModel = droneCameraModel.payloadInfo
            val widgetModelList = payloadInfoModel.widgetModels
            payloadInfo.payloadName = payloadInfoModel.name
            payloadInfo.isSetThirdPartyCameraParam = true
            payloadInfo.customActionInfos = widgetModelList?.map {
                WaylineCustomPayloadActionInfo().apply {
                    actionName = it.name
                    actionType = it.type
                    actionIndex = it.index
                    maxParamValue = it.minValue.toDouble()
                    minParamValue = it.maxValue.toDouble()
                }
            }?.toMutableList() ?: mutableListOf()
        }
        return payloadInfo;
    }

    override fun transTo(r: WaylinePayloadInfo): DroneCameraModel {
        val droneCameraModel = DroneCameraModel()
        droneCameraModel.cameraIndex = r.payloadPositionIndex
        val cameraTypePair = transPayloadTypeTo(r.payloadType)
        droneCameraModel.cameraType = cameraTypePair.first.value()
        droneCameraModel.payloadCameraType = cameraTypePair.second.value()
        droneCameraModel.cameraName = CameraUtil.getCameraDisplayName() //c todo

        if (r.customActionInfos != null && r.customActionInfos.size > 0) {
            val payloadInfo = PayloadInfoModel()
            payloadInfo.name = r.payloadName
            payloadInfo.widgetModels = r.customActionInfos.map {
                PayloadInfoModel.PayloadWidgetInfo().apply {
                    name = it.actionName
                    type = it.actionType
                    index = it.actionIndex
                    minValue = it.minParamValue.toInt()
                    maxValue = it.maxParamValue.toInt()
                }
            }.toMutableList()
            droneCameraModel.payloadInfo = payloadInfo
            droneCameraModel.cameraName = droneCameraModel.cameraName
        }
        return droneCameraModel
    }

    private fun transPayloadTypeFrom(cameraType : Int, payloadCameraType : Int) : WaylinePayloadType {
        return when {
            cameraType == CameraType.DJICameraTypeGD610DualLight.value() -> WaylinePayloadType.ZENMUSE_H20
            cameraType == CameraType.DJICameraTypeGD610TripleLight.value() -> WaylinePayloadType.ZENMUSE_H20T
            cameraType == CameraType.GD612.value() -> WaylinePayloadType.ZENMUSE_H20N
            cameraType == CameraType.DJICameraTypePM320DualLight.value() -> WaylinePayloadType.PM320_DUAL
            cameraType == CameraType.DJICameraTypePM320TripleLight.value() -> WaylinePayloadType.PM320_TRIPLE
            cameraType == CameraType.WM265_E.value() -> WaylinePayloadType.WM265E
            cameraType == CameraType.WM265_T.value() -> WaylinePayloadType.WM265T
            cameraType == CameraType.WM265_M.value() -> WaylinePayloadType.WM265M
            cameraType == CameraType.ZENMUSE_X30.value() -> WaylinePayloadType.ZENMUSE_Z30
            cameraType == CameraType.ZENMUSE_XT2.value() -> WaylinePayloadType.ZENMUSE_XT2
            cameraType == CameraType.ZENMUSE_XTS.value() -> WaylinePayloadType.ZENMUSE_XTS
            cameraType == CameraType.Payload.value() && payloadCameraType == PayloadCameraType.EP600.value() -> WaylinePayloadType.ZENMUSE_P1
            cameraType == CameraType.Payload.value() && payloadCameraType == PayloadCameraType.EP800.value() -> WaylinePayloadType.ZENMUSE_L1
            cameraType == CameraType.Payload.value() && payloadCameraType == PayloadCameraType.UNKNOWN.value() -> WaylinePayloadType.PAYLOAD_CAMERA
            else -> WaylinePayloadType.UNKNOWN
        }
    }

    private fun transPayloadTypeTo(payloadType: WaylinePayloadType) : Pair<CameraType, PayloadCameraType> {
        return when(payloadType) {
            WaylinePayloadType.ZENMUSE_H20 -> Pair(CameraType.DJICameraTypeGD610DualLight, PayloadCameraType.UNKNOWN)
            WaylinePayloadType.ZENMUSE_H20T -> Pair(CameraType.DJICameraTypeGD610TripleLight, PayloadCameraType.UNKNOWN)
            WaylinePayloadType.ZENMUSE_H20N -> Pair(CameraType.GD612, PayloadCameraType.UNKNOWN)
            WaylinePayloadType.PM320_DUAL -> Pair(CameraType.DJICameraTypePM320DualLight, PayloadCameraType.UNKNOWN)
            WaylinePayloadType.PM320_TRIPLE -> Pair(CameraType.DJICameraTypePM320TripleLight, PayloadCameraType.UNKNOWN)
            WaylinePayloadType.WM265E -> Pair(CameraType.WM265_E, PayloadCameraType.UNKNOWN)
            WaylinePayloadType.WM265T -> Pair(CameraType.WM265_T, PayloadCameraType.UNKNOWN)
            WaylinePayloadType.WM265M -> Pair(CameraType.WM265_M, PayloadCameraType.UNKNOWN)
            WaylinePayloadType.ZENMUSE_Z30 -> Pair(CameraType.ZENMUSE_X30, PayloadCameraType.UNKNOWN)
            WaylinePayloadType.ZENMUSE_XTS -> Pair(CameraType.ZENMUSE_XTS, PayloadCameraType.UNKNOWN)
            WaylinePayloadType.ZENMUSE_XT2 -> Pair(CameraType.ZENMUSE_XT2, PayloadCameraType.UNKNOWN)
            WaylinePayloadType.ZENMUSE_P1 -> Pair(CameraType.Payload, PayloadCameraType.EP600)
            WaylinePayloadType.ZENMUSE_L1 -> Pair(CameraType.Payload, PayloadCameraType.EP800)
            WaylinePayloadType.PAYLOAD_CAMERA -> Pair(CameraType.Payload, PayloadCameraType.UNKNOWN)
            else -> Pair(CameraType.UNKNOWN, PayloadCameraType.UNKNOWN);
        }
    }
}