package com.dji.wpmzsdk.common.utils.kml.transfrom;



import com.dji.wpmzsdk.common.utils.kml.model.PointTurnMode;

import dji.sdk.wpmz.value.mission.WaylineWaypointYawPathMode;


/**
 * Description :
 *
 * @author : devin.xu
 * @filename : WaylineTurnModeTransform
 * @time : 2020/11/25
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class WaylineTurnModeTransform implements ModelTransform<PointTurnMode, WaylineWaypointYawPathMode> {
    @Override
    public WaylineWaypointYawPathMode transFrom(PointTurnMode pointTurnMode) {
        if (pointTurnMode != null) {
            switch (pointTurnMode) {
                case AUTO:
                    return WaylineWaypointYawPathMode.FOLLOW_BAD_ARC;
                case CLOCKWISE:
                    return WaylineWaypointYawPathMode.CLOCKWISE;
                case COUNTER_CLOCKWISE:
                    return WaylineWaypointYawPathMode.COUNTER_CLOCKWISE;
                default:
                    return WaylineWaypointYawPathMode.FOLLOW_BAD_ARC;
            }
        }
        return WaylineWaypointYawPathMode.FOLLOW_BAD_ARC;
    }

    @Override
    public PointTurnMode transTo(WaylineWaypointYawPathMode waylineWaypointTurnEvenlyPathMode) {
        if (waylineWaypointTurnEvenlyPathMode != null) {
            switch (waylineWaypointTurnEvenlyPathMode) {
                case FOLLOW_BAD_ARC:
                    return PointTurnMode.AUTO;
                case CLOCKWISE:
                    return PointTurnMode.CLOCKWISE;
                case COUNTER_CLOCKWISE:
                    return PointTurnMode.COUNTER_CLOCKWISE;
                default:
                    return PointTurnMode.AUTO;
            }
        }
        return PointTurnMode.AUTO;
    }
}
