package com.dji.wpmzsdk.interfaces;


import com.dji.wpmzsdk.common.data.HeightMode;
import com.dji.wpmzsdk.common.data.KMZInfo;
import com.dji.wpmzsdk.common.data.Template;


import dji.sdk.wpmz.value.mission.Wayline;
import dji.sdk.wpmz.value.mission.WaylineCheckErrorMsg;
import dji.sdk.wpmz.value.mission.WaylineMission;
import dji.sdk.wpmz.value.mission.WaylineMissionConfig;

/**
 * @author feel.feng
 * @time 2023/06/21 3:26 下午
 * @description:
 */
//Doc key: IWPMZManager
public interface IWPMZManager {
    //Doc key: IWPMZManager_getKMZInfo
    /**
     * 获取kmz 中wayline Template config等信息
     * @param kmzPath
     */
    KMZInfo getKMZInfo(String kmzPath);

    //Doc key: IWPMZManager_generateKMZFileTemplate
    /**
     * 可根据该接口生成kmz,生成kmz包含template,以及wayline可支持pilot编辑
     * @param kmzPath 保存kmz 的文件路径
     * @param waylineMission
     * @param config wayline 全局配置
     * @param waylineTemplate  航线生成的模版类
     */
    void generateKMZFile(String kmzPath , WaylineMission waylineMission , WaylineMissionConfig config , Template waylineTemplate  );
    //Doc key: IWPMZManager_generateKMZFileWayline
    /**
     * 可根据该接口生成kmz ,编辑Wayline对象，生成的kmz 只有wayline文件不支持pilot编辑
     * @param kmzPath 保存kmz 的文件路径
     * @param waylineMission
     * @param config wayline 全局配置
     * @param wayline 航线生成的模版类
     */
    void generateKMZFile(String kmzPath , WaylineMission waylineMission , WaylineMissionConfig config , Wayline wayline);
    //Doc key: IWPMZManager_checkValidation
    /**
     * 检查kmz文件中wayline字段值是否正常
     * 提供部分字段检查
     * @param kmzPath  需要检查的kmz路径
     * @return
     */
     WaylineCheckErrorMsg checkValidation(String kmzPath);

    //Doc key: IWPMZManager_transKMLtoKMZ
    /**
     * kml文件转换为kmz ,用于DJI
     * @param kmlImportPath 需要转换的kml文件路径
     * @param kmzOutPath  指定转出的kmz路径
     */
    boolean transKMLtoKMZ(String kmlImportPath , String kmzOutPath);

    //Doc key: IWPMZManager_transKMLtoKMZHeightMode
    /**
     * kml文件转换为kmz , 非DJI生成的kml文件需要指定高度模式。
     * @param kmlImportPath 需要转换的kml文件路径
     * @param kmzOutPath 指定转出的kmz路径
     * @param transParams 高度模式与任务类型参数
     */
    boolean transKMLtoKMZ(String kmlImportPath , String kmzOutPath , HeightMode transParams);


}
