package com.dji.wpmzsdk.manager;

import static com.dji.wpmzsdk.common.utils.kml.KMLUtil.VERSION;

import android.content.Context;
import android.util.Log;

import com.dji.industry.pilot.missionflight.library.MissionImportParams;
import com.dji.wpmzsdk.common.data.HeightMode;

import com.dji.wpmzsdk.common.utils.FileUtils;
import com.dji.wpmzsdk.common.utils.kml.GeoidManager;
import com.dji.wpmzsdk.common.utils.kml.KMLCreateMissionUtil;
import com.dji.wpmzsdk.common.utils.kml.KMLException;
import com.dji.wpmzsdk.common.utils.kml.KMLFileParseInfo;
import com.dji.wpmzsdk.common.utils.kml.KMLUtil;
import com.dji.wpmzsdk.common.utils.kml.data.MissionImportHeightMode;
import com.dji.wpmzsdk.common.utils.kml.data.MissionType;
import com.dji.wpmzsdk.interfaces.IWPMZManager;
import com.dji.wpmzsdk.common.data.KMZInfo;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;


import com.dji.wpmzsdk.common.data.Template;
import com.dji.wpmzsdk.common.utils.PPalGenerator;
import com.dji.wpmzsdk.common.utils.TemplateTransform;

import org.dom4j.DocumentException;

import dji.sdk.wpmz.jni.JNIWPMZManager;
import dji.sdk.wpmz.value.mission.Wayline;
import dji.sdk.wpmz.value.mission.WaylineCheckErrorMsg;
import dji.sdk.wpmz.value.mission.WaylineExecuteMissionConfig;
import dji.sdk.wpmz.value.mission.WaylineMission;
import dji.sdk.wpmz.value.mission.WaylineMissionConfig;
import dji.sdk.wpmz.value.mission.WaylineTemplate;

/**
 * @author feel.feng
 * @time 2023/06/21 5:20 下午
 * @description:
 */
public class WPMZManager implements IWPMZManager {

    private final String TAG = "WPMZManager";

    private Context context;

    private WPMZManager() {

    }

    public  void init(Context context) {
        this.context = context;
        KMLUtil.setContext(context);
        String dirPath = FileUtils.getDJIDirPath(context);
        FileUtils.createFile(dirPath + "/CACHE");
        FileUtils.copyAssetsDirToSDCard(context ,"geoid_data/WW15MGH.DAC" ,dirPath );
        GeoidManager.getInstance().openGeoid96M150(dirPath + "/WW15MGH.DAC");
    }



    public static WPMZManager getInstance() {
        return WPMZManagerHolder.INSTANCE;
    }


    private static class WPMZManagerHolder {
        private static final WPMZManager INSTANCE = new WPMZManager();
    }


    @Override
    public KMZInfo getKMZInfo(String kmzPath) {
        KMZInfo kmzInfo = new KMZInfo();
        kmzInfo.setWaylineMissionConfigParseInfo(JNIWPMZManager.getWaylineMissionConfig(VERSION , kmzPath));
        kmzInfo.setWaylineMissionParseInfo(JNIWPMZManager.getWaylineMission(VERSION,kmzPath));
        kmzInfo.setWaylineTemplatesParseInfo(TemplateTransform.INSTANCE.transTemplateParseInfo(JNIWPMZManager.getWaylineTemplates(VERSION ,kmzPath)));
        kmzInfo.setWaylineWaylinesParseInfo(JNIWPMZManager.getWaylines(VERSION , kmzPath));
        return kmzInfo;
    }

    @Override
    public void generateKMZFile(String kmzPath , WaylineMission waylineMission , WaylineMissionConfig config , Template waylineTemplate  ){
        // template参数
        List<WaylineTemplate> templateList = new ArrayList<>();
        WaylineTemplate template = TemplateTransform.INSTANCE.transToWaylineTemplate(waylineTemplate);
        templateList.add(template);
        //executionConfig 参数
        WaylineExecuteMissionConfig executeMissionConfig =  createExecuteConfig(config);
        //生成waylines
        PPalGenerator generator = new PPalGenerator();
        PPalGenerator.PPALParam param =
                new PPalGenerator.PPALParam(waylineMission
                        , config,
                        createExecuteConfig(config), templateList);
        List<Wayline> waylines = generator.getWaylines(param);
        //生成kmz
        JNIWPMZManager.generateKMZFile(VERSION, waylineMission
                , config, templateList, waylines, executeMissionConfig,
                new ArrayList<>(), new ArrayList<>(), kmzPath);
    }

    @Override
    public void generateKMZFile(String kmzPath, WaylineMission waylineMission, WaylineMissionConfig config, Wayline wayline) {
        // template参数
        List<WaylineTemplate> templateList = new ArrayList<>();
        WaylineTemplate waylineTemplate = new WaylineTemplate();
        templateList.add(waylineTemplate); // todo
        List<Wayline> waylines = new ArrayList<>();
        waylines.add(wayline);
        //executionConfig 参数
        WaylineExecuteMissionConfig executeMissionConfig =  createExecuteConfig(config);
        //生成kmz
        JNIWPMZManager.generateKMZFile(VERSION, waylineMission
                , config, templateList, waylines, executeMissionConfig,
                new ArrayList<>(), new ArrayList<>(), kmzPath);
    }

    @Override
    public WaylineCheckErrorMsg checkValidation(String kmzPath) {
        return JNIWPMZManager.checkWPMZValid(VERSION , kmzPath);
    }

    @Override
    public boolean transKMLtoKMZ(String kmlImportPath, String kmzOutPath) {
        KMLFileParseInfo parseInfo =  KMLUtil.getKMLType(kmlImportPath);
        if (parseInfo.getFileType() != KMLFileParseInfo.KMLFileType.MISSION || parseInfo.getMissionType() != MissionType.Waypoint) {
            Log.e(TAG , "transKMLtoKMZ failed ,kml is not dji file  or mission type !");
            return false;
        }
        MissionImportParams params = new MissionImportParams();
        params.setFileType(KMLFileParseInfo.KMLFileType.MISSION);
        params.setMissionType(MissionType.Waypoint);

        try {
            Object object = KMLUtil.importMission( params , kmlImportPath);
            KMLUtil.saveKMLImportMission(object , kmlImportPath);

        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG , "trans failed" + e.getMessage());
            return false;

        }
        Log.d(TAG , "trans finished");
        return true;


    }
    // 只支持Original 类型，如果是Mission 类型则调用transKMLtoKMZ(String kmlImportPath, String kmzOutPath)

    @Override
    public boolean transKMLtoKMZ(String kmlImportPath, String kmzOutPath, HeightMode heightMode) {
        KMLFileParseInfo parseInfo =  KMLUtil.getKMLType(kmlImportPath);
        if (parseInfo.getFileType() == KMLFileParseInfo.KMLFileType.MISSION) {
           return transKMLtoKMZ(kmlImportPath , kmzOutPath);
        }
        MissionImportParams missionImportParams = new MissionImportParams();
        missionImportParams.setHeightMode(transHeightMode(heightMode));
        missionImportParams.setFileType(KMLFileParseInfo.KMLFileType.ORIGINAL);
        missionImportParams.setMissionType(MissionType.Waypoint);
        try {
            Object object = new KMLCreateMissionUtil().createMission(missionImportParams, kmlImportPath);
            KMLUtil.saveLocalMission(object , kmzOutPath);
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG , "trans failed" + e.getMessage());
            return  false;
        }

        Log.d(TAG , "trans finished");
        return  true;
    }

    private MissionImportHeightMode transHeightMode(HeightMode heightMode) {
        MissionImportHeightMode missionImportHeightMode = MissionImportHeightMode.WGS84;
        switch (heightMode){
            case RELATIVE:
                missionImportHeightMode =  MissionImportHeightMode.RELATIVE;
                break;
            case WGS84:
                missionImportHeightMode =  MissionImportHeightMode.WGS84;
                break;
            case EGM96:
                missionImportHeightMode =  MissionImportHeightMode.EGM96;
                break;
            default:
                break;
        }
        return missionImportHeightMode;
    }




    private WaylineExecuteMissionConfig createExecuteConfig(WaylineMissionConfig config) {
        WaylineExecuteMissionConfig executeMissionConfig = new WaylineExecuteMissionConfig();
        executeMissionConfig.setDroneInfo(config.getDroneInfo());
        executeMissionConfig.setExitOnRCLostBehavior(config.getExitOnRCLostBehavior());
        executeMissionConfig.setFinishAction(config.getFinishAction());
        executeMissionConfig.setExitOnRCLostType(config.getExitOnRCLostType());
        executeMissionConfig.setFlyToWaylineMode(config.getFlyToWaylineMode());
        executeMissionConfig.setGlobalRTHHeight(config.getGlobalRTHHeight());
        executeMissionConfig.setIsGlobalRTHHeightSet(config.getIsGlobalRTHHeightSet());
        executeMissionConfig.setGlobalTransitionalSpeed(config.getGlobalTransitionalSpeed());
        executeMissionConfig.setIsGlobalRTHHeightSet(config.getIsGlobalRTHHeightSet());
        executeMissionConfig.setPayloadInfo(config.getPayloadInfo());
        executeMissionConfig.setSecurityTakeOffHeight(config.getSecurityTakeOffHeight());
        executeMissionConfig.setIsSecurityTakeOffHeightSet(config.getIsSecurityTakeOffHeightSet());
        return  executeMissionConfig;
    }

}
