/*
 * Decompiled with CFR 0.152.
 */
package dji.sdk.wpmz.value.mission;

import dji.sdk.wpmz.jni.JNIProguardKeepTag;
import dji.sdk.wpmz.value.ByteResult;
import dji.sdk.wpmz.value.ByteStream;
import dji.sdk.wpmz.value.ByteStreamHelper;
import dji.sdk.wpmz.value.base.DJIValue;
import java.util.Objects;
import org.json.JSONObject;

public class ActionSprayCapacityParam
implements DJIValue,
JNIProguardKeepTag,
ByteStream {
    Integer payloadPositionIndex = 0;
    Double sprayVolum = 0.0;

    public ActionSprayCapacityParam() {
    }

    public ActionSprayCapacityParam(Integer payloadPositionIndex, Double sprayVolum) {
        if (payloadPositionIndex != null) {
            this.payloadPositionIndex = payloadPositionIndex;
        }
        if (sprayVolum != null) {
            this.sprayVolum = sprayVolum;
        }
    }

    public static ActionSprayCapacityParam fromJson(String jsonString) {
        ActionSprayCapacityParam tmpValueResult_ = new ActionSprayCapacityParam();
        JSONObject jsonObj = null;
        try {
            jsonObj = new JSONObject(jsonString);
            tmpValueResult_.payloadPositionIndex = jsonObj.getInt("payloadPositionIndex");
            tmpValueResult_.sprayVolum = jsonObj.getDouble("sprayVolum");
        }
        catch (Exception e) {
            tmpValueResult_ = null;
        }
        return tmpValueResult_;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = null;
        try {
            json = new JSONObject();
            if (null != this.payloadPositionIndex) {
                json.put("payloadPositionIndex", (Object)this.payloadPositionIndex);
            }
            if (null != this.sprayVolum) {
                json.put("sprayVolum", (Object)this.sprayVolum);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    @Override
    public int serializedLength() {
        int serializedLength = 0;
        serializedLength += ByteStreamHelper.integerGetLength(this.payloadPositionIndex);
        return serializedLength += ByteStreamHelper.doubleGetLength(this.sprayVolum);
    }

    @Override
    public int toBytes(byte[] resultBytes, int serializedIndex) {
        serializedIndex = ByteStreamHelper.integerToBytes(resultBytes, this.payloadPositionIndex, serializedIndex);
        serializedIndex = ByteStreamHelper.doubleToBytes(resultBytes, this.sprayVolum, serializedIndex);
        return serializedIndex;
    }

    @Override
    public byte[] toBytes() {
        byte[] resultBytes = new byte[this.serializedLength()];
        this.toBytes(resultBytes, 0);
        return resultBytes;
    }

    @Override
    public int fromBytes(byte[] data, int deserilizationIndex) {
        ByteResult<Integer> tmpPayloadPositionIndex = ByteStreamHelper.integerFromBytes(data, deserilizationIndex);
        this.payloadPositionIndex = (Integer)tmpPayloadPositionIndex.result;
        deserilizationIndex = tmpPayloadPositionIndex.endIndex;
        ByteResult<Double> tmpSprayVolum = ByteStreamHelper.doubleFromBytes(data, deserilizationIndex);
        this.sprayVolum = (Double)tmpSprayVolum.result;
        deserilizationIndex = tmpSprayVolum.endIndex;
        return deserilizationIndex;
    }

    public Integer getPayloadPositionIndex() {
        return this.payloadPositionIndex;
    }

    public void setPayloadPositionIndex(Integer payloadPositionIndex) {
        this.payloadPositionIndex = payloadPositionIndex;
    }

    public Double getSprayVolum() {
        return this.sprayVolum;
    }

    public void setSprayVolum(Double sprayVolum) {
        this.sprayVolum = sprayVolum;
    }

    public String toString() {
        JSONObject json = this.toJson();
        return json != null ? this.toJson().toString() : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionSprayCapacityParam)) {
            return false;
        }
        ActionSprayCapacityParam that = (ActionSprayCapacityParam)o;
        return Objects.equals(this.payloadPositionIndex, that.payloadPositionIndex) && Objects.equals(this.sprayVolum, that.sprayVolum);
    }

    public int hashCode() {
        return Objects.hash(this.payloadPositionIndex, this.sprayVolum);
    }
}

