/*
 * Decompiled with CFR 0.152.
 */
package com.eriwen.gradle.js.source.internal;

import com.eriwen.gradle.js.source.JavaScriptProcessingChain;
import com.eriwen.gradle.js.source.JavaScriptSourceSet;
import com.eriwen.gradle.js.source.internal.DefaultJavaScriptSourceSet;
import com.eriwen.gradle.js.source.internal.InternalGradle;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Namer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DefaultNamedDomainObjectList;
import org.gradle.api.tasks.SourceTask;

public class DefaultJavaScriptProcessingChain
extends DefaultNamedDomainObjectList<SourceTask>
implements JavaScriptProcessingChain {
    private final DefaultJavaScriptSourceSet source;
    private final Project project;

    public DefaultJavaScriptProcessingChain(Project project, DefaultJavaScriptSourceSet source) {
        super(SourceTask.class, InternalGradle.toInstantiator(project), (Namer)new Task.Namer());
        this.source = source;
        this.project = project;
        this.wireChain();
    }

    @Override
    public JavaScriptSourceSet getSource() {
        return this.source;
    }

    protected void wireChain() {
        this.all((Action)new Action<SourceTask>(){

            public void execute(final SourceTask sourceTask) {
                sourceTask.source(new Object[]{new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        int index = DefaultJavaScriptProcessingChain.this.indexOf(sourceTask);
                        if (index == -1) {
                            return null;
                        }
                        if (index == 0) {
                            return DefaultJavaScriptProcessingChain.this.getSource().getJs();
                        }
                        SourceTask previous = (SourceTask)DefaultJavaScriptProcessingChain.this.get(index - 1);
                        return previous.getOutputs().getFiles();
                    }
                }});
            }
        });
    }

    @Override
    public <T extends SourceTask> T task(Class<T> type) {
        return this.task(this.calculateName(type), type);
    }

    @Override
    public <T extends SourceTask> T task(String name, Class<T> type) {
        return this.task(name, type, null);
    }

    @Override
    public <T extends SourceTask> T task(Class<T> type, Closure closure) {
        return this.task(this.calculateName(type), type, closure);
    }

    @Override
    public <T extends SourceTask> T task(String name, Class<T> type, Closure closure) {
        SourceTask task = (SourceTask)this.project.task(Collections.singletonMap("type", type), name, closure);
        this.add(task);
        return (T)task;
    }

    protected String calculateName(Class<? extends SourceTask> type) {
        String name = type.getName();
        if (name.endsWith("Task")) {
            name = name.substring(0, name.length() - 4);
        }
        return this.source.getName() + name;
    }
}

