package com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser;


import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.KeyDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.type.MapType;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap;

public class ImmutableMapDeserializer
 extends GuavaImmutableMapDeserializer<ImmutableMap<Object, Object>>
{
    public ImmutableMapDeserializer(MapType type, KeyDeserializer keyDeser,
            TypeDeserializer typeDeser, JsonDeserializer<?> deser)
    {
        super(type, keyDeser, typeDeser, deser);
    }

    @Override
    public ImmutableMapDeserializer withResolved(KeyDeserializer keyDeser,
            TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        return new ImmutableMapDeserializer(_mapType, keyDeser,
                typeDeser, valueDeser);
    }
    
    @Override
    protected ImmutableMap.Builder<Object, Object> createBuilder() {
        return ImmutableMap.builder();
    }

}
