/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.StageStats;
import com.facebook.presto.jdbc.internal.client.StatementStats;
import java.util.Objects;
import java.util.Optional;

public final class QueryStats {
    private final String queryId;
    private final String state;
    private final boolean queued;
    private final boolean scheduled;
    private final int nodes;
    private final int totalSplits;
    private final int queuedSplits;
    private final int runningSplits;
    private final int completedSplits;
    private final long userTimeMillis;
    private final long cpuTimeMillis;
    private final long wallTimeMillis;
    private final long processedRows;
    private final long processedBytes;
    private final Optional<StageStats> rootStage;

    public QueryStats(String queryId, String state, boolean queued, boolean scheduled, int nodes, int totalSplits, int queuedSplits, int runningSplits, int completedSplits, long userTimeMillis, long cpuTimeMillis, long wallTimeMillis, long processedRows, long processedBytes, Optional<StageStats> rootStage) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.queued = queued;
        this.scheduled = scheduled;
        this.nodes = nodes;
        this.totalSplits = totalSplits;
        this.queuedSplits = queuedSplits;
        this.runningSplits = runningSplits;
        this.completedSplits = completedSplits;
        this.userTimeMillis = userTimeMillis;
        this.cpuTimeMillis = cpuTimeMillis;
        this.wallTimeMillis = wallTimeMillis;
        this.processedRows = processedRows;
        this.processedBytes = processedBytes;
        this.rootStage = Objects.requireNonNull(rootStage, "rootStage is null");
    }

    static QueryStats create(String queryId, StatementStats stats) {
        return new QueryStats(queryId, stats.getState(), stats.isQueued(), stats.isScheduled(), stats.getNodes(), stats.getTotalSplits(), stats.getQueuedSplits(), stats.getRunningSplits(), stats.getCompletedSplits(), stats.getUserTimeMillis(), stats.getCpuTimeMillis(), stats.getWallTimeMillis(), stats.getProcessedRows(), stats.getProcessedBytes(), Optional.ofNullable(stats.getRootStage()).map(StageStats::create));
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getState() {
        return this.state;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public int getNodes() {
        return this.nodes;
    }

    public int getTotalSplits() {
        return this.totalSplits;
    }

    public int getQueuedSplits() {
        return this.queuedSplits;
    }

    public int getRunningSplits() {
        return this.runningSplits;
    }

    public int getCompletedSplits() {
        return this.completedSplits;
    }

    public long getUserTimeMillis() {
        return this.userTimeMillis;
    }

    public long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    public long getWallTimeMillis() {
        return this.wallTimeMillis;
    }

    public long getProcessedRows() {
        return this.processedRows;
    }

    public long getProcessedBytes() {
        return this.processedBytes;
    }

    public Optional<StageStats> getRootStage() {
        return this.rootStage;
    }
}

