/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.LongArrayBlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.DecimalType;
import com.facebook.presto.jdbc.internal.spi.type.SqlDecimal;
import java.math.BigInteger;

final class ShortDecimalType
extends DecimalType {
    ShortDecimalType(int precision, int scale) {
        super(precision, scale, Long.TYPE);
        this.validatePrecisionScale(precision, scale, 17);
    }

    @Override
    public int getFixedSize() {
        return 8;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new LongArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, blockBuilderStatus.getMaxBlockSizeInBytes() / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new LongArrayBlockBuilder(new BlockBuilderStatus(), positionCount);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long unscaledValue = block.getLong(position, 0);
        return new SqlDecimal(BigInteger.valueOf(unscaledValue), this.getPrecision(), this.getScale());
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long rightValue;
        long leftValue = leftBlock.getLong(leftPosition, 0);
        return leftValue == (rightValue = rightBlock.getLong(rightPosition, 0));
    }

    @Override
    public long hash(Block block, int position) {
        return block.getLong(position, 0);
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long leftValue = leftBlock.getLong(leftPosition, 0);
        long rightValue = rightBlock.getLong(rightPosition, 0);
        return Long.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position, 0)).closeEntry();
        }
    }

    @Override
    public long getLong(Block block, int position) {
        return block.getLong(position, 0);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeLong(value).closeEntry();
    }
}

