/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.NCUSocketFactory;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.util.FS;

public class SshAgentSessionFactory
extends JschConfigSessionFactory {
    private final Log log;
    private String knownHostsOrNull;
    private String identityFile;
    private String passphraseOrNull;

    public SshAgentSessionFactory(Log log, String knownHostsOrNull, String identityFile, String passphraseOrNull) {
        this.log = log;
        this.setKnownHosts(knownHostsOrNull);
        this.setIdentityFile(identityFile);
        this.setPassphrase(passphraseOrNull);
    }

    void setKnownHosts(String knownHosts) {
        this.knownHostsOrNull = knownHosts;
    }

    void setIdentityFile(String identityFile) {
        this.identityFile = identityFile;
    }

    void setPassphrase(String passphrase) {
        this.passphraseOrNull = passphrase;
    }

    String getKnownHostsOrNull() {
        return this.knownHostsOrNull;
    }

    String getIdentityFile() {
        return this.identityFile;
    }

    String getPassphraseOrNull() {
        return this.passphraseOrNull;
    }

    protected void configure(OpenSshConfig.Host host, Session sn) {
    }

    protected JSch createDefaultJSch(FS fs) throws JSchException {
        SSHAgentConnector con = null;
        try {
            if (SSHAgentConnector.isConnectorAvailable()) {
                NCUSocketFactory usf = new NCUSocketFactory();
                con = new SSHAgentConnector((USocketFactory)usf);
            }
        }
        catch (AgentProxyException e) {
            this.log.warn((CharSequence)"Failed to connect to SSH-agent", (Throwable)e);
        }
        JSch jsch = super.createDefaultJSch(fs);
        if (con != null) {
            JSch.setConfig((String)"PreferredAuthentications", (String)"publickey");
            RemoteIdentityRepository identityRepository = new RemoteIdentityRepository((Connector)con);
            jsch.setIdentityRepository((IdentityRepository)identityRepository);
            this.log.debug((CharSequence)String.format("Jsch configured to use %s", con.getName()));
        }
        if (this.knownHostsOrNull != null) {
            jsch.setKnownHosts(this.knownHostsOrNull);
            this.log.debug((CharSequence)String.format("Jsch configured to use known hostfile %s", this.knownHostsOrNull));
        }
        if (this.identityFile != null) {
            jsch.addIdentity(this.identityFile, this.passphraseOrNull);
            this.log.debug((CharSequence)String.format("Jsch configured to use identity file %s", this.identityFile));
        }
        return jsch;
    }
}

