/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendException;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.LoggerFactory;

public abstract class AbstractFrontendMojo
extends AbstractMojo {
    @Component
    protected MojoExecution execution;
    @Parameter(property="skipTests", required=false, defaultValue="false")
    protected Boolean skipTests;
    @Parameter(defaultValue="${basedir}", property="workingDirectory", required=false)
    protected File workingDirectory;
    @Parameter(defaultValue="${basedir}", property="installDirectory", required=false)
    protected File installDirectory;

    private boolean skipTestPhase() {
        return this.skipTests != false && this.isTestingPhase();
    }

    private boolean isTestingPhase() {
        String phase = this.execution.getLifecyclePhase();
        return phase.equals("test") || phase.equals("integration-test");
    }

    protected abstract void execute(FrontendPluginFactory var1) throws FrontendException;

    protected abstract boolean skipExecution();

    public void execute() throws MojoFailureException {
        if (!this.skipTestPhase() && !this.skipExecution()) {
            try {
                this.execute(new FrontendPluginFactory(this.workingDirectory, this.installDirectory));
            }
            catch (TaskRunnerException e) {
                throw new MojoFailureException("Failed to run task", (Throwable)e);
            }
            catch (FrontendException e) {
                throw MojoUtils.toMojoFailureException(e);
            }
        } else {
            LoggerFactory.getLogger(AbstractFrontendMojo.class).info("Skipping test phase.");
        }
    }
}

