/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback.json;

import com.github.loki4j.pkg.dslplatform.json.NumberConverter;
import com.github.loki4j.pkg.dslplatform.json.RawJsonWriter;

public class JsonEventWriter {
    private final RawJsonWriter raw;

    public JsonEventWriter(int initialCapacity) {
        this.raw = new RawJsonWriter(initialCapacity);
    }

    public void writeBeginObject() {
        this.raw.writeByte((byte)123);
    }

    public void writeEndObject() {
        this.raw.writeByte((byte)125);
    }

    public void writeFieldSeparator() {
        this.raw.writeByte((byte)44);
    }

    public void writeStringField(String fieldName, String value) {
        this.raw.writeAsciiString(fieldName);
        this.raw.writeByte((byte)58);
        if (value != null) {
            this.raw.writeString(value);
        } else {
            this.raw.writeNull();
        }
    }

    public void writeNumberField(String fieldName, long value) {
        this.raw.writeAsciiString(fieldName);
        this.raw.writeByte((byte)58);
        NumberConverter.serialize(value, this.raw);
    }

    public String toString() {
        return this.raw.toString();
    }
}

