/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers;

import com.github.mkolisnyk.cucumber.reporting.types.breakdown.DimensionValue;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.AndMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.ContainerMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.ErrorMessageMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.FailedStepMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.FeatureMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.Matcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.NotMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.OrMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.ScenarioMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.StepMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.StepParamMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.StepSequenceMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.TagMatcher;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseMatcher
implements Matcher {
    private static final Map<DimensionValue, Matcher> DIMENSION_MATCHER_MAP = new HashMap<DimensionValue, Matcher>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DimensionValue.FEATURE, new FeatureMatcher());
            this.put(DimensionValue.SCENARIO, new ScenarioMatcher());
            this.put(DimensionValue.TAG, new TagMatcher());
            this.put(DimensionValue.STEP, new StepMatcher());
            this.put(DimensionValue.CONTAINER, new ContainerMatcher());
            this.put(DimensionValue.STEP_PARAM, new StepParamMatcher());
            this.put(DimensionValue.NOT, new NotMatcher());
            this.put(DimensionValue.AND, new AndMatcher());
            this.put(DimensionValue.OR, new OrMatcher());
            this.put(DimensionValue.STEP_SEQUENCE, new StepSequenceMatcher());
            this.put(DimensionValue.ERROR_MESSAGE, new ErrorMessageMatcher());
            this.put(DimensionValue.FAILED_STEP, new FailedStepMatcher());
        }
    };

    protected boolean stringMatches(String expected, String expression) {
        return StringUtils.isNotEmpty((CharSequence)expected) && (expected.equals(expression) || expected.matches(expression));
    }

    public static Matcher create(DimensionValue value) {
        return DIMENSION_MATCHER_MAP.get((Object)value);
    }
}

