/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.software.os.impl;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.software.os.FileSystem;
import oshi.json.software.os.OSFileStore;
import oshi.json.util.PropertiesUtil;

public class FileSystemImpl
extends AbstractOshiJsonObject
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.software.os.FileSystem fileSystem;

    public FileSystemImpl(oshi.software.os.FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public OSFileStore[] getFileStores() {
        oshi.software.os.OSFileStore[] fs = this.fileSystem.getFileStores();
        OSFileStore[] fileStores = new OSFileStore[fs.length];
        for (int i = 0; i < fs.length; ++i) {
            fileStores[i] = new OSFileStore(fs[i]);
        }
        return fileStores;
    }

    @Override
    public long getOpenFileDescriptors() {
        return this.fileSystem.getOpenFileDescriptors();
    }

    @Override
    public long getMaxFileDescriptors() {
        return this.fileSystem.getMaxFileDescriptors();
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.fileSystem.fileStores")) {
            JsonArrayBuilder fileStoreArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (OSFileStore fileStore : this.getFileStores()) {
                fileStoreArrayBuilder.add((JsonValue)fileStore.toJSON(properties));
            }
            json.add("fileStores", (JsonValue)fileStoreArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.fileSystem.openFileDescriptors")) {
            json.add("openFileDescriptors", this.getOpenFileDescriptors());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.fileSystem.maxFileDescriptors")) {
            json.add("maxFileDescriptors", this.getMaxFileDescriptors());
        }
        return json.build();
    }
}

