/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx.model;

public enum TraceLevel {
    VERBOSE("V"),
    DEBUG("D"),
    INFO("I"),
    WARNING("W"),
    ERROR("E"),
    ASSERT("A"),
    WTF("F");

    private final String value;

    private TraceLevel(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static TraceLevel getTraceLevel(char traceString) {
        TraceLevel traceLevel;
        switch (traceString) {
            case 'V': {
                traceLevel = VERBOSE;
                break;
            }
            case 'A': {
                traceLevel = ASSERT;
                break;
            }
            case 'I': {
                traceLevel = INFO;
                break;
            }
            case 'W': {
                traceLevel = WARNING;
                break;
            }
            case 'E': {
                traceLevel = ERROR;
                break;
            }
            case 'F': {
                traceLevel = WTF;
                break;
            }
            default: {
                traceLevel = DEBUG;
            }
        }
        return traceLevel;
    }
}

