/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx.presenter;

import com.github.pedrovgs.lynx.model.Trace;
import java.util.LinkedList;
import java.util.List;

class TraceBuffer {
    private int bufferSize;
    private final List<Trace> traces;

    TraceBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.traces = new LinkedList<Trace>();
    }

    void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.removeExceededTracesIfNeeded();
    }

    int add(List<Trace> traces) {
        this.traces.addAll(traces);
        return this.removeExceededTracesIfNeeded();
    }

    List<Trace> getTraces() {
        return this.traces;
    }

    public int getCurrentNumberOfTraces() {
        return this.traces.size();
    }

    public void clear() {
        this.traces.clear();
    }

    private int removeExceededTracesIfNeeded() {
        int tracesToDiscard = this.getNumberOfTracesToDiscard();
        if (tracesToDiscard > 0) {
            this.discardTraces(tracesToDiscard);
        }
        return tracesToDiscard;
    }

    private int getNumberOfTracesToDiscard() {
        int currentTracesSize = this.traces.size();
        int tracesToDiscard = currentTracesSize - this.bufferSize;
        tracesToDiscard = tracesToDiscard < 0 ? 0 : tracesToDiscard;
        return tracesToDiscard;
    }

    private void discardTraces(int tracesToDiscard) {
        for (int i = 0; i < tracesToDiscard; ++i) {
            this.traces.remove(0);
        }
    }
}

