/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import com.google.common.base.Optional;
import japicmp.cli.JApiCli;
import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.config.Options;
import japicmp.maven.ConfigurationFile;
import japicmp.maven.Dependency;
import japicmp.maven.DependencyDescriptor;
import japicmp.maven.MavenParameters;
import japicmp.maven.Parameter;
import japicmp.maven.PluginParameters;
import japicmp.maven.Version;
import japicmp.maven.VersionChange;
import japicmp.model.AccessModifier;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.output.semver.SemverOut;
import japicmp.output.stdout.StdoutOutputGenerator;
import japicmp.output.xml.XmlOutput;
import japicmp.output.xml.XmlOutputGenerator;
import japicmp.output.xml.XmlOutputGeneratorOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="cmp", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.VERIFY)
public class JApiCmpMojo
extends AbstractMojo {
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Version oldVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<DependencyDescriptor> oldVersions;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Version newVersion;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<DependencyDescriptor> newVersions;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private Parameter parameter;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> dependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> oldClassPathDependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private List<Dependency> newClassPathDependencies;
    @org.apache.maven.plugins.annotations.Parameter(required=false)
    private String skip;
    @org.apache.maven.plugins.annotations.Parameter(property="project.build.directory", required=true)
    private File projectBuildDir;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> artifactRepositories;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojoExecution;

    private static <T> T notNull(T value, String msg) throws MojoFailureException {
        if (value == null) {
            throw new MojoFailureException(msg);
        }
        return value;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenParameters mavenParameters = new MavenParameters(this.artifactRepositories, this.artifactFactory, this.localRepository, this.artifactResolver, this.mavenProject, this.mojoExecution);
        PluginParameters pluginParameters = new PluginParameters(this.skip, this.newVersion, this.oldVersion, this.parameter, this.dependencies, (Optional<File>)Optional.of((Object)this.projectBuildDir), (Optional<String>)Optional.absent(), true, this.oldVersions, this.newVersions, this.oldClassPathDependencies, this.newClassPathDependencies);
        this.executeWithParameters(pluginParameters, mavenParameters);
    }

    Optional<XmlOutput> executeWithParameters(PluginParameters pluginParameters, MavenParameters mavenParameters) throws MojoFailureException {
        if (Boolean.TRUE.toString().equalsIgnoreCase(pluginParameters.getSkipParam())) {
            this.getLog().info((CharSequence)"Skipping execution because parameter 'skip' was set to true.");
            return Optional.absent();
        }
        if (this.filterModule(pluginParameters)) {
            return Optional.absent();
        }
        ArrayList<File> oldArchives = new ArrayList<File>();
        ArrayList<File> newArchives = new ArrayList<File>();
        this.populateArchivesListsFromParameters(pluginParameters, mavenParameters, oldArchives, newArchives);
        VersionChange versionChange = new VersionChange(oldArchives, newArchives);
        Options options = this.createOptions(pluginParameters.getParameterParam(), oldArchives, newArchives);
        List<JApiClass> jApiClasses = this.compareArchives(options, pluginParameters, mavenParameters);
        try {
            File jApiCmpBuildDir = this.createJapiCmpBaseDir(pluginParameters);
            String diffOutput = this.generateDiffOutput(jApiClasses, options);
            this.createFileAndWriteTo(diffOutput, jApiCmpBuildDir, mavenParameters);
            XmlOutput xmlOutput = this.generateXmlOutput(jApiClasses, jApiCmpBuildDir, options, mavenParameters, pluginParameters);
            if (pluginParameters.isWriteToFiles()) {
                List filesWritten = XmlOutputGenerator.writeToFiles((Options)options, (XmlOutput)xmlOutput);
                for (File file : filesWritten) {
                    this.getLog().info((CharSequence)("Written file '" + file.getAbsolutePath() + "'."));
                }
            }
            this.breakBuildIfNecessary(jApiClasses, pluginParameters.getParameterParam(), versionChange, options);
            return Optional.of((Object)xmlOutput);
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Failed to construct output directory: %s", e.getMessage()), (Throwable)e);
        }
    }

    private boolean filterModule(PluginParameters pluginParameters) {
        if (this.mavenProject != null) {
            List<String> packagingSupporteds = pluginParameters.getParameterParam().getPackagingSupporteds();
            if (packagingSupporteds != null && !packagingSupporteds.isEmpty()) {
                if (!packagingSupporteds.contains(this.mavenProject.getPackaging())) {
                    this.getLog().info((CharSequence)"Filtered according to packagingFilter");
                    return true;
                }
            } else {
                this.getLog().debug((CharSequence)"No packaging support defined, no filtering");
            }
            if ("pom".equals(this.mavenProject.getPackaging())) {
                String skipPomModulesAsString;
                boolean skipPomModules = true;
                Parameter parameterParam = pluginParameters.getParameterParam();
                if (parameterParam != null && (skipPomModulesAsString = parameterParam.getSkipPomModules()) != null) {
                    skipPomModules = Boolean.valueOf(skipPomModulesAsString);
                }
                if (skipPomModules) {
                    this.getLog().info((CharSequence)"Skipping execution because packaging of this module is 'pom'.");
                    return true;
                }
            }
        }
        return false;
    }

    private void populateArchivesListsFromParameters(PluginParameters pluginParameters, MavenParameters mavenParameters, List<File> oldArchives, List<File> newArchives) throws MojoFailureException {
        String message;
        if (pluginParameters.getOldVersionParam() != null) {
            oldArchives.addAll(this.retrieveFileFromConfiguration(pluginParameters.getOldVersionParam(), "oldVersion", mavenParameters, pluginParameters));
        }
        if (pluginParameters.getOldVersionsParam() != null) {
            for (DependencyDescriptor dependencyDescriptor : pluginParameters.getOldVersionsParam()) {
                if (dependencyDescriptor == null) continue;
                oldArchives.addAll(this.retrieveFileFromConfiguration(dependencyDescriptor, "oldVersions", mavenParameters, pluginParameters));
            }
        }
        if (pluginParameters.getNewVersionParam() != null) {
            newArchives.addAll(this.retrieveFileFromConfiguration(pluginParameters.getNewVersionParam(), "newVersion", mavenParameters, pluginParameters));
        }
        if (pluginParameters.getNewVersionsParam() != null) {
            for (DependencyDescriptor dependencyDescriptor : pluginParameters.getNewVersionsParam()) {
                if (dependencyDescriptor == null) continue;
                newArchives.addAll(this.retrieveFileFromConfiguration(dependencyDescriptor, "newVersions", mavenParameters, pluginParameters));
            }
        }
        if (oldArchives.size() == 0) {
            message = "Please provide at least one resolvable old version using one of the configuration elements <oldVersion/> or <oldVersions/>.";
            if (this.ignoreNonResolvableArtifacts(pluginParameters)) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message);
            }
        }
        if (newArchives.size() == 0) {
            message = "Please provide at least one resolvable new version using one of the configuration elements <newVersion/> or <newVersions/>.";
            if (this.ignoreNonResolvableArtifacts(pluginParameters)) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message);
            }
        }
    }

    private void breakBuildIfNecessary(List<JApiClass> jApiClasses, Parameter parameterParam, VersionChange versionChange, Options options) throws MojoFailureException {
        if (this.breakBuildOnModificationsParameter(parameterParam)) {
            for (JApiClass jApiClass : jApiClasses) {
                if (jApiClass.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
                throw new MojoFailureException(String.format("Breaking the build because there is at least one modified class: %s", jApiClass.getFullyQualifiedName()));
            }
        }
        if (this.breakBuildOnBinaryIncompatibleModifications(parameterParam)) {
            for (JApiClass jApiClass : jApiClasses) {
                if (jApiClass.getChangeStatus() == JApiChangeStatus.UNCHANGED || jApiClass.isBinaryCompatible()) continue;
                throw new MojoFailureException(String.format("Breaking the build because there is at least one binary incompatible class: %s", jApiClass.getFullyQualifiedName()));
            }
        }
        if (this.breakBuildOnSourceIncompatibleModifications(parameterParam)) {
            for (JApiClass jApiClass : jApiClasses) {
                if (jApiClass.getChangeStatus() == JApiChangeStatus.UNCHANGED || jApiClass.isSourceCompatible()) continue;
                throw new MojoFailureException(String.format("Breaking the build because there is at least one source incompatible class: %s", jApiClass.getFullyQualifiedName()));
            }
        }
        if (this.breakBuildBasedOnSemanticVersioning(parameterParam)) {
            VersionChange.ChangeType changeType = versionChange.computeChangeType();
            SemverOut semverOut = new SemverOut(options, jApiClasses);
            String semver = semverOut.generate();
            if (changeType == VersionChange.ChangeType.MINOR && semver.equals("1.0.0")) {
                throw new MojoFailureException("Versions of archives indicate a minor change but binary incompatible changes found.");
            }
            if (changeType == VersionChange.ChangeType.PATCH && semver.equals("1.0.0")) {
                throw new MojoFailureException("Versions of archives indicate a patch change but binary incompatible changes found.");
            }
            if (changeType == VersionChange.ChangeType.PATCH && semver.equals("0.1.0")) {
                throw new MojoFailureException("Versions of archives indicate a patch change but binary compatible changes found.");
            }
            if (changeType == VersionChange.ChangeType.UNCHANGED && semver.equals("1.0.0")) {
                throw new MojoFailureException("Versions of archives indicate no API changes but binary incompatible changes found.");
            }
            if (changeType == VersionChange.ChangeType.UNCHANGED && semver.equals("0.1.0")) {
                throw new MojoFailureException("Versions of archives indicate no API changes but binary compatible changes found.");
            }
            if (changeType == VersionChange.ChangeType.UNCHANGED && semver.equals("0.0.1")) {
                throw new MojoFailureException("Versions of archives indicate no API changes but found API changes.");
            }
        }
    }

    private Options createOptions(Parameter parameterParam, List<File> oldVersions, List<File> newVersions) throws MojoFailureException {
        Options options = Options.newDefault();
        options.getOldArchives().addAll(oldVersions);
        options.getNewArchives().addAll(newVersions);
        if (parameterParam != null) {
            String noAnnotationsString;
            String htmlStylesheet;
            String ignoreMissingClassesString;
            String includeSyntheticString;
            List<String> includes;
            List<String> excludes;
            String onlyModified;
            String onlyBinaryIncompatible;
            String accessModifierArg = parameterParam.getAccessModifier();
            if (accessModifierArg != null) {
                try {
                    AccessModifier accessModifier = AccessModifier.valueOf((String)accessModifierArg.toUpperCase());
                    options.setAccessModifier(accessModifier);
                }
                catch (IllegalArgumentException e) {
                    throw new MojoFailureException(String.format("Invalid value for option accessModifier: %s. Possible values are: %s.", accessModifierArg, AccessModifier.listOfAccessModifier()));
                }
            }
            if ((onlyBinaryIncompatible = parameterParam.getOnlyBinaryIncompatible()) != null) {
                Boolean booleanOnlyBinaryIncompatible = Boolean.valueOf(onlyBinaryIncompatible);
                options.setOutputOnlyBinaryIncompatibleModifications(booleanOnlyBinaryIncompatible.booleanValue());
            }
            if ((onlyModified = parameterParam.getOnlyModified()) != null) {
                Boolean booleanOnlyModified = Boolean.valueOf(onlyModified);
                options.setOutputOnlyModifications(booleanOnlyModified.booleanValue());
            }
            if ((excludes = parameterParam.getExcludes()) != null) {
                for (String exclude : excludes) {
                    options.addExcludeFromArgument(Optional.fromNullable((Object)exclude));
                }
            }
            if ((includes = parameterParam.getIncludes()) != null) {
                for (String include : includes) {
                    options.addIncludeFromArgument(Optional.fromNullable((Object)include));
                }
            }
            if ((includeSyntheticString = parameterParam.getIncludeSynthetic()) != null) {
                Boolean includeSynthetic = Boolean.valueOf(includeSyntheticString);
                options.setIncludeSynthetic(includeSynthetic.booleanValue());
            }
            if ((ignoreMissingClassesString = parameterParam.getIgnoreMissingClasses()) != null) {
                Boolean ignoreMissingClasses = Boolean.valueOf(ignoreMissingClassesString);
                options.setIgnoreMissingClasses(ignoreMissingClasses.booleanValue());
            }
            if ((htmlStylesheet = parameterParam.getHtmlStylesheet()) != null) {
                options.setHtmlStylesheet(Optional.of((Object)htmlStylesheet));
            }
            if ((noAnnotationsString = parameterParam.getNoAnnotations()) != null) {
                Boolean noAnnotations = Boolean.valueOf(noAnnotationsString);
                options.setNoAnnotations(noAnnotations.booleanValue());
            }
        }
        return options;
    }

    private boolean breakBuildOnModificationsParameter(Parameter parameterParam) {
        boolean retVal = false;
        if (parameterParam != null) {
            retVal = Boolean.valueOf(parameterParam.getBreakBuildOnModifications());
        }
        return retVal;
    }

    private boolean breakBuildOnBinaryIncompatibleModifications(Parameter parameterParam) {
        boolean retVal = false;
        if (parameterParam != null) {
            retVal = Boolean.valueOf(parameterParam.getBreakBuildOnBinaryIncompatibleModifications());
        }
        return retVal;
    }

    private boolean breakBuildOnSourceIncompatibleModifications(Parameter parameter) {
        boolean retVal = false;
        if (parameter != null) {
            retVal = Boolean.valueOf(parameter.getBreakBuildOnSourceIncompatibleModifications());
        }
        return retVal;
    }

    private boolean breakBuildBasedOnSemanticVersioning(Parameter parameter) {
        boolean retVal = false;
        if (parameter != null) {
            retVal = Boolean.valueOf(parameter.getBreakBuildBasedOnSemanticVersioning());
        }
        return retVal;
    }

    private void createFileAndWriteTo(String diffOutput, File jApiCmpBuildDir, MavenParameters mavenParameters) throws IOException, MojoFailureException {
        File output = new File(jApiCmpBuildDir.getCanonicalPath() + File.separator + this.createFilename(mavenParameters) + ".diff");
        this.writeToFile(diffOutput, output);
    }

    private File createJapiCmpBaseDir(PluginParameters pluginParameters) throws MojoFailureException {
        if (pluginParameters.getProjectBuildDirParam().isPresent()) {
            try {
                File projectBuildDirParam = (File)pluginParameters.getProjectBuildDirParam().get();
                if (projectBuildDirParam != null) {
                    File jApiCmpBuildDir = new File(projectBuildDirParam.getCanonicalPath() + File.separator + "japicmp");
                    boolean mkdirs = jApiCmpBuildDir.mkdirs();
                    if (mkdirs || jApiCmpBuildDir.isDirectory() && jApiCmpBuildDir.canWrite()) {
                        return jApiCmpBuildDir;
                    }
                    throw new MojoFailureException(String.format("Failed to create directory '%s'.", jApiCmpBuildDir.getAbsolutePath()));
                }
                throw new MojoFailureException("Maven parameter projectBuildDir is not set.");
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to create output directory: " + e.getMessage(), (Throwable)e);
            }
        }
        if (pluginParameters.getOutputDirectory().isPresent()) {
            String outputDirectory = (String)pluginParameters.getOutputDirectory().get();
            if (outputDirectory != null) {
                File outputDirFile = new File(outputDirectory);
                boolean mkdirs = outputDirFile.mkdirs();
                if (mkdirs || outputDirFile.isDirectory() && outputDirFile.canWrite()) {
                    return outputDirFile;
                }
                throw new MojoFailureException(String.format("Failed to create directory '%s'.", outputDirFile.getAbsolutePath()));
            }
            throw new MojoFailureException("Maven parameter outputDirectory is not set.");
        }
        throw new MojoFailureException("None of the two parameters projectBuildDir and outputDirectory are present");
    }

    private String generateDiffOutput(List<JApiClass> jApiClasses, Options options) {
        StdoutOutputGenerator stdoutOutputGenerator = new StdoutOutputGenerator(options, jApiClasses);
        return stdoutOutputGenerator.generate();
    }

    private XmlOutput generateXmlOutput(List<JApiClass> jApiClasses, File jApiCmpBuildDir, Options options, MavenParameters mavenParameters, PluginParameters pluginParameters) throws IOException, MojoFailureException {
        String filename = this.createFilename(mavenParameters);
        options.setXmlOutputFile(Optional.of((Object)(jApiCmpBuildDir.getCanonicalPath() + File.separator + filename + ".xml")));
        options.setHtmlOutputFile(Optional.of((Object)(jApiCmpBuildDir.getCanonicalPath() + File.separator + filename + ".html")));
        SemverOut semverOut = new SemverOut(options, jApiClasses);
        XmlOutputGeneratorOptions xmlOutputGeneratorOptions = new XmlOutputGeneratorOptions();
        xmlOutputGeneratorOptions.setCreateSchemaFile(true);
        xmlOutputGeneratorOptions.setSemanticVersioningInformation(semverOut.generate());
        if (pluginParameters.getParameterParam() != null) {
            xmlOutputGeneratorOptions.setTitle(pluginParameters.getParameterParam().getHtmlTitle());
        }
        XmlOutputGenerator xmlGenerator = new XmlOutputGenerator(jApiClasses, options, xmlOutputGeneratorOptions);
        return xmlGenerator.generate();
    }

    private String createFilename(MavenParameters mavenParameters) {
        String filename = "japicmp";
        String executionId = mavenParameters.getMojoExecution().getExecutionId();
        if (executionId != null && !"default".equals(executionId)) {
            filename = executionId;
        }
        return filename;
    }

    private List<JApiClass> compareArchives(Options options, PluginParameters pluginParameters, MavenParameters mavenParameters) throws MojoFailureException {
        JarArchiveComparatorOptions comparatorOptions = JarArchiveComparatorOptions.of((Options)options);
        this.setUpClassPath(comparatorOptions, pluginParameters, mavenParameters);
        JarArchiveComparator jarArchiveComparator = new JarArchiveComparator(comparatorOptions);
        return jarArchiveComparator.compare(options.getOldArchives(), options.getNewArchives());
    }

    private void setUpClassPath(JarArchiveComparatorOptions comparatorOptions, PluginParameters pluginParameters, MavenParameters mavenParameters) throws MojoFailureException {
        if (pluginParameters != null) {
            if (pluginParameters.getDependenciesParam() != null) {
                if (pluginParameters.getOldClassPathDependencies() != null || pluginParameters.getNewClassPathDependencies() != null) {
                    throw new MojoFailureException("Please specify either a <dependencies/> element or the two elements <oldClassPathDependencies/> and <newClassPathDependencies/>. With <dependencies/> you can specify one common classpath for both versions and with <oldClassPathDependencies/> and <newClassPathDependencies/> a separate classpath for the new and old version.");
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Element <dependencies/> found. Using " + JApiCli.ClassPathMode.ONE_COMMON_CLASSPATH));
                }
                for (Dependency dependency : pluginParameters.getDependenciesParam()) {
                    List<File> files = this.resolveDependencyToFile("dependencies", dependency, mavenParameters, true, pluginParameters);
                    for (File file : files) {
                        comparatorOptions.getClassPathEntries().add(file.getAbsolutePath());
                    }
                    comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH);
                }
            } else if (pluginParameters.getOldClassPathDependencies() != null || pluginParameters.getNewClassPathDependencies() != null) {
                List<File> files;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("At least one of the elements <oldClassPathDependencies/> or <newClassPathDependencies/> found. Using " + JApiCli.ClassPathMode.TWO_SEPARATE_CLASSPATHS));
                }
                if (pluginParameters.getOldClassPathDependencies() != null) {
                    for (Dependency dependency : pluginParameters.getOldClassPathDependencies()) {
                        files = this.resolveDependencyToFile("oldClassPathDependencies", dependency, mavenParameters, true, pluginParameters);
                        for (File file : files) {
                            comparatorOptions.getOldClassPath().add(file.getAbsolutePath());
                        }
                    }
                }
                if (pluginParameters.getNewClassPathDependencies() != null) {
                    for (Dependency dependency : pluginParameters.getNewClassPathDependencies()) {
                        files = this.resolveDependencyToFile("newClassPathDependencies", dependency, mavenParameters, true, pluginParameters);
                        for (File file : files) {
                            comparatorOptions.getNewClassPath().add(file.getAbsolutePath());
                        }
                    }
                }
                comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS);
            } else {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("None of the elements <oldClassPathDependencies/>, <newClassPathDependencies/> or <dependencies/> found. Using " + JApiCli.ClassPathMode.ONE_COMMON_CLASSPATH));
                }
                comparatorOptions.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH);
            }
        }
        this.setUpClassPathUsingMavenProject(comparatorOptions, mavenParameters, pluginParameters);
    }

    private void setUpClassPathUsingMavenProject(JarArchiveComparatorOptions comparatorOptions, MavenParameters mavenParameters, PluginParameters pluginParameters) throws MojoFailureException {
        JApiCmpMojo.notNull(mavenParameters.getMavenProject(), "Maven parameter mavenProject should be provided by maven container.");
        Set dependencyArtifacts = mavenParameters.getMavenProject().getArtifacts();
        HashSet<String> classPathEntries = new HashSet<String>();
        for (Artifact artifact : dependencyArtifacts) {
            String scope = artifact.getScope();
            if ("test".equals(scope) || artifact.isOptional()) continue;
            Set<Artifact> artifacts = this.resolveArtifact(artifact, mavenParameters, false, pluginParameters);
            for (Artifact resolvedArtifact : artifacts) {
                String absolutePath;
                File resolvedFile = resolvedArtifact.getFile();
                if (resolvedFile == null || classPathEntries.contains(absolutePath = resolvedFile.getAbsolutePath())) continue;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Adding to classpath: " + absolutePath + "; scope: " + scope));
                }
                classPathEntries.add(absolutePath);
            }
        }
        for (String classPathEntry : classPathEntries) {
            comparatorOptions.getClassPathEntries().add(classPathEntry);
        }
    }

    private List<File> retrieveFileFromConfiguration(DependencyDescriptor dependencyDescriptor, String parameterName, MavenParameters mavenParameters, PluginParameters pluginParameters) throws MojoFailureException {
        List<File> files;
        if (dependencyDescriptor instanceof Dependency) {
            Dependency dependency = (Dependency)dependencyDescriptor;
            files = this.resolveDependencyToFile(parameterName, dependency, mavenParameters, false, pluginParameters);
        } else if (dependencyDescriptor instanceof ConfigurationFile) {
            ConfigurationFile configurationFile = (ConfigurationFile)dependencyDescriptor;
            files = this.resolveConfigurationFileToFile(parameterName, configurationFile);
        } else {
            throw new MojoFailureException("DependencyDescriptor is not of type <dependency/> nor of type <configurationFile/>.");
        }
        return files;
    }

    private List<File> retrieveFileFromConfiguration(Version version, String parameterName, MavenParameters mavenParameters, PluginParameters pluginParameters) throws MojoFailureException {
        if (version != null) {
            Dependency dependency = version.getDependency();
            if (dependency != null) {
                return this.resolveDependencyToFile(parameterName, dependency, mavenParameters, false, pluginParameters);
            }
            if (version.getFile() != null) {
                ConfigurationFile configurationFile = version.getFile();
                return this.resolveConfigurationFileToFile(parameterName, configurationFile);
            }
            throw new MojoFailureException("Missing configuration parameter 'dependency'.");
        }
        throw new MojoFailureException(String.format("Missing configuration parameter: %s", parameterName));
    }

    private List<File> resolveConfigurationFileToFile(String parameterName, ConfigurationFile configurationFile) throws MojoFailureException {
        String path = configurationFile.getPath();
        if (path == null) {
            throw new MojoFailureException(String.format("The path element in the configuration of the plugin is missing for %s.", parameterName));
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new MojoFailureException(String.format("The path '%s' does not point to an existing file.", path));
        }
        if (!file.isFile() || !file.canRead()) {
            throw new MojoFailureException(String.format("The file given by path '%s' is either not a file or is not readable.", path));
        }
        return Collections.singletonList(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<File> resolveDependencyToFile(String parameterName, Dependency dependency, MavenParameters mavenParameters, boolean transitively, PluginParameters pluginParameters) throws MojoFailureException {
        ArrayList<File> files = new ArrayList<File>();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Trying to resolve dependency '" + dependency + "' to file."));
        }
        if (dependency.getSystemPath() == null) {
            String descriptor = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
            this.getLog().debug((CharSequence)(parameterName + ": " + descriptor));
            Set<Artifact> artifacts = this.resolveArtifact(dependency, mavenParameters, transitively, pluginParameters);
            for (Artifact artifact : artifacts) {
                File file = artifact.getFile();
                if (file == null) throw new MojoFailureException(String.format("Could not resolve dependency with descriptor '%s'.", descriptor));
                files.add(file);
            }
            if (files.size() != 0) return files;
            String message = String.format("Could not resolve dependency with descriptor '%s'.", descriptor);
            if (!this.ignoreNonResolvableArtifacts(pluginParameters)) throw new MojoFailureException(message);
            this.getLog().warn((CharSequence)message);
            return files;
        } else {
            File file;
            String systemPath = dependency.getSystemPath();
            Pattern pattern = Pattern.compile("\\$\\{([^\\}])");
            Matcher matcher = pattern.matcher(systemPath);
            if (matcher.matches()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String property = matcher.group(i);
                    String propertyResolved = mavenParameters.getMavenProject().getProperties().getProperty(property);
                    if (propertyResolved == null) {
                        throw new MojoFailureException("Could not resolve property '" + property + "'.");
                    }
                    systemPath = systemPath.replaceAll("${" + property + "}", propertyResolved);
                }
            }
            if (!(file = new File(systemPath)).exists()) {
                throw new MojoFailureException("File '" + file.getAbsolutePath() + "' does not exist.");
            }
            if (!file.canRead()) {
                throw new MojoFailureException("File '" + file.getAbsolutePath() + "' is not readable.");
            }
            files.add(file);
        }
        return files;
    }

    private void writeToFile(String output, File outputfile) throws MojoFailureException, IOException {
        try (OutputStreamWriter fileWriter = null;){
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outputfile), Charset.forName("UTF-8"));
            fileWriter.write(output);
            this.getLog().info((CharSequence)("Written file '" + outputfile.getAbsolutePath() + "'."));
        }
    }

    private Set<Artifact> resolveArtifact(Dependency dependency, MavenParameters mavenParameters, boolean transitively, PluginParameters pluginParameters) throws MojoFailureException {
        JApiCmpMojo.notNull(mavenParameters.getArtifactRepositories(), "Maven parameter artifactRepositories should be provided by maven container.");
        Artifact artifact = mavenParameters.getArtifactFactory().createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
        return this.resolveArtifact(artifact, mavenParameters, transitively, pluginParameters);
    }

    private Set<Artifact> resolveArtifact(Artifact artifact, MavenParameters mavenParameters, boolean transitively, PluginParameters pluginParameters) throws MojoFailureException {
        Set artifacts;
        String message;
        ArtifactResolutionResult resolutionResult;
        JApiCmpMojo.notNull(mavenParameters.getLocalRepository(), "Maven parameter localRepository should be provided by maven container.");
        JApiCmpMojo.notNull(mavenParameters.getArtifactResolver(), "Maven parameter artifactResolver should be provided by maven container.");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(mavenParameters.getLocalRepository());
        request.setRemoteRepositories(mavenParameters.getArtifactRepositories());
        request.setResolutionFilter(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                boolean include = true;
                if (artifact != null && artifact.isOptional()) {
                    include = false;
                }
                return include;
            }
        });
        if (transitively) {
            request.setResolveTransitively(true);
        }
        if ((resolutionResult = mavenParameters.getArtifactResolver().resolve(request)).hasExceptions()) {
            List exceptions = resolutionResult.getExceptions();
            message = "Could not resolve " + artifact;
            if (this.ignoreNonResolvableArtifacts(pluginParameters)) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message, (Throwable)exceptions.get(0));
            }
        }
        if ((artifacts = resolutionResult.getArtifacts()).size() == 0) {
            message = "Could not resolve " + artifact;
            if (this.ignoreNonResolvableArtifacts(pluginParameters)) {
                this.getLog().warn((CharSequence)message);
            } else {
                throw new MojoFailureException(message);
            }
        }
        return artifacts;
    }

    private boolean ignoreNonResolvableArtifacts(PluginParameters pluginParameters) {
        boolean ignoreNonResolvableArtifacts = false;
        Parameter parameterParam = pluginParameters.getParameterParam();
        if (parameterParam != null) {
            String ignoreNonResolvableArtifactsAsString = parameterParam.getIgnoreNonResolvableArtifacts();
            if (Boolean.TRUE.toString().equalsIgnoreCase(ignoreNonResolvableArtifactsAsString)) {
                ignoreNonResolvableArtifacts = true;
            }
        }
        return ignoreNonResolvableArtifacts;
    }
}

