/*
 * Decompiled with CFR 0.152.
 */
package jscover.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import jscover.maven.JSCoverMojoBase;
import jscover.maven.TestType;
import jscover.maven.WebDriverRunner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public abstract class JSCoverMojo
extends JSCoverMojoBase {
    protected WebDriver webDriver;
    @Parameter
    protected String testIncludes = "*.html";
    @Parameter
    protected String testExcludes;
    @Parameter
    protected TestType testType = TestType.Jasmine;
    @Parameter
    protected int lineCoverageMinimum;
    @Parameter
    protected int branchCoverageMinimum;
    @Parameter
    protected int functionCoverageMinimum;
    @Parameter
    protected String webDriverClassName = PhantomJSDriver.class.getName();
    @Parameter
    protected String testRunnerClassName;
    @Parameter
    protected Properties systemProperties = new Properties();
    @Parameter
    protected boolean reportLCOV;
    @Parameter
    protected boolean reportCoberturaXML;
    @Parameter
    protected int timeOutSeconds = 10;
    @Parameter
    protected String httpProxy;

    protected void setSystemProperties() {
        for (Object key : this.systemProperties.keySet()) {
            System.setProperty((String)key, (String)this.systemProperties.get(key));
        }
    }

    protected List<File> getTestFiles() throws MojoExecutionException {
        return this.getTestFiles(this.testDirectory);
    }

    protected List<File> getTestFiles(File testDirectory) throws MojoExecutionException {
        try {
            List files = FileUtils.getFiles((File)testDirectory, (String)this.testIncludes, (String)this.testExcludes);
            if (files.isEmpty()) {
                throw new MojoExecutionException("No tests found in " + testDirectory.getAbsolutePath() + ". Includes:" + this.testIncludes + ", Excludes:" + this.testExcludes);
            }
            return files;
        }
        catch (IOException | IllegalStateException e) {
            throw new MojoExecutionException("Problem finding test pages", e);
        }
    }

    protected WebDriverRunner getWebDriverRunner() throws MojoExecutionException {
        if (this.testRunnerClassName != null) {
            try {
                return (WebDriverRunner)Class.forName(this.testRunnerClassName).newInstance();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        WebDriverRunner webDriverRunner = this.testType.getWebDriverRunner();
        webDriverRunner.setTimeOutSeconds(this.timeOutSeconds);
        return webDriverRunner;
    }

    protected WebDriver getWebDriver() {
        Class<WebDriver> webDriverClass = this.getWebDriverClass();
        DesiredCapabilities desiredCapabilities = this.getDesiredCapabilities();
        try {
            if (this.webDriverClassName.contains("Chrome")) {
                ChromeOptions options = new ChromeOptions();
                options.addArguments(new String[]{"--allow-file-access-from-files"});
                desiredCapabilities.setCapability("chromeOptions", (Object)options);
            }
            this.webDriver = webDriverClass.getConstructor(Capabilities.class).newInstance(desiredCapabilities);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.webDriver;
    }

    protected DesiredCapabilities getDesiredCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setJavascriptEnabled(true);
        if (this.httpProxy != null) {
            Proxy proxy = new Proxy().setHttpProxy(this.httpProxy);
            capabilities.setCapability("proxy", (Object)proxy);
        }
        return capabilities;
    }

    protected Class<WebDriver> getWebDriverClass() {
        try {
            return Class.forName(this.webDriverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopWebClient() {
        try {
            this.webDriver.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.webDriver.quit();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

