/*
 * Decompiled with CFR 0.152.
 */
package jscover.maven;

import com.google.javascript.jscomp.parsing.Config;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jscover.ConfigurationCommon;
import jscover.filesystem.ConfigurationForFS;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class JSCoverMojoBase
extends AbstractMojo {
    protected ConfigurationCommon defaults = new ConfigurationCommon();
    @Parameter
    protected boolean includeBranch = this.defaults.isIncludeBranch();
    @Parameter
    protected boolean includeFunction = this.defaults.isIncludeFunction();
    @Parameter
    protected boolean localStorage = true;
    @Parameter
    protected boolean includeUnloadedJS = this.defaults.isIncludeUnloadedJS();
    @Parameter
    protected final List<String> instrumentPathArgs = new ArrayList<String>();
    @Parameter
    protected File reportDir = new File("target/reports/jscover-maven");
    @Parameter
    protected String ECMAVersion = this.defaults.getECMAVersion().name();
    @Parameter
    protected boolean detectCoalesce = this.defaults.isDetectCoalesce();
    @Parameter(required=true)
    protected File testDirectory = new File("src/test/javascript/spec");

    protected void setCommonConfiguration(ConfigurationCommon config) throws MojoExecutionException {
        config.setIncludeBranch(this.includeBranch);
        config.setIncludeFunction(this.includeFunction);
        config.setLocalStorage(this.localStorage);
        config.setIncludeUnloadedJS(this.includeUnloadedJS);
        config.setECMAVersion(Config.LanguageMode.valueOf((String)this.ECMAVersion));
        config.setDetectCoalesce(this.detectCoalesce);
        for (String instrumentArg : this.instrumentPathArgs) {
            if (instrumentArg.startsWith("--no-instrument=")) {
                config.addNoInstrument(instrumentArg);
                continue;
            }
            if (instrumentArg.startsWith("--no-instrument-reg=")) {
                config.addNoInstrumentReg(instrumentArg);
                continue;
            }
            if (instrumentArg.startsWith("--only-instrument-reg=")) {
                config.addOnlyInstrumentReg(instrumentArg);
                continue;
            }
            throw new MojoExecutionException(String.format("Invalid instrument path option '%s'", instrumentArg));
        }
    }

    protected ConfigurationForFS getConfigurationForFS(File srcDir, List<String> excludeArgs) throws MojoExecutionException {
        ConfigurationForFS config = new ConfigurationForFS();
        this.setCommonConfiguration((ConfigurationCommon)config);
        config.setSrcDir(srcDir);
        config.setDestDir(this.reportDir);
        for (String excludeArg : excludeArgs) {
            if (excludeArg.startsWith("--exclude=")) {
                config.addExclude(excludeArg);
                continue;
            }
            if (excludeArg.startsWith("--exclude-reg=")) {
                config.addExcludeReg(excludeArg);
                continue;
            }
            throw new MojoExecutionException(String.format("Invalid exclude argument '%s'", excludeArg));
        }
        return config;
    }
}

