/*
 * Decompiled with CFR 0.152.
 */
package jscover.maven;

import java.io.File;
import java.util.function.Function;
import jscover.maven.WebDriverRunner;
import jscover.report.ConfigurationForReport;
import jscover.report.Main;
import jscover.util.IoUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

class JSCoverTestRunner {
    private Log log = new SystemStreamLog();
    private Main main = new Main();
    protected final WebDriver webClient;
    protected final WebDriverRunner webDriverRunner;
    private final int lineCoverageMinimum;
    private final int branchCoverageMinimum;
    private final int functionCoverageMinimum;
    protected final boolean reportLCOV;
    protected final boolean reportCoberturaXML;
    protected IoUtils ioUtils = IoUtils.getInstance();

    public JSCoverTestRunner(WebDriver webClient, WebDriverRunner webDriverRunner, int lineCoverageMinimum, int branchCoverageMinimum, int functionCoverageMinimum, boolean reportLCOV, boolean reportCoberturaXML) {
        this.webClient = webClient;
        this.webDriverRunner = webDriverRunner;
        this.reportLCOV = reportLCOV;
        this.reportCoberturaXML = reportCoberturaXML;
        this.lineCoverageMinimum = lineCoverageMinimum;
        this.branchCoverageMinimum = branchCoverageMinimum;
        this.functionCoverageMinimum = functionCoverageMinimum;
    }

    protected void generateOtherReportFormats(File dir) {
        if (this.reportLCOV || this.reportCoberturaXML) {
            ConfigurationForReport configurationForReport = new ConfigurationForReport();
            this.main.initialize();
            configurationForReport.setProperties(Main.properties);
            configurationForReport.setJsonDirectory(dir);
            configurationForReport.setSourceDirectory(new File(dir, "original-src"));
            this.main.setConfig(configurationForReport);
            if (this.reportLCOV) {
                this.log.info((CharSequence)"Generating LCOV coverage data file");
                this.main.generateLCovDataFile();
            }
            if (this.reportCoberturaXML) {
                this.log.info((CharSequence)"Generating Cobertura coverage data file");
                this.main.saveCoberturaXml();
            }
        }
    }

    protected void verifyTotal() throws MojoFailureException {
        this.webClient.findElement(By.id((String)"summaryTab")).click();
        new WebDriverWait(this.webClient, 1L).until((Function)ExpectedConditions.textToBePresentInElementLocated((By)By.id((String)"summaryTotal"), (String)"%"));
        this.verifyField("Line", "summaryTotal", this.lineCoverageMinimum);
        this.verifyField("Branch", "branchSummaryTotal", this.branchCoverageMinimum);
        this.verifyField("Function", "functionSummaryTotal", this.functionCoverageMinimum);
    }

    private void verifyField(String coverageName, String fieldName, int percentageMin) throws MojoFailureException {
        int percentage = this.extractInt(this.webClient.findElement(By.id((String)fieldName)).getText());
        this.log.info((CharSequence)(coverageName + " coverage minimum: " + percentageMin + " actual: " + percentage));
        if (percentage < percentageMin) {
            throw new MojoFailureException(String.format("%s coverage %d less than %d", coverageName, percentage, percentageMin));
        }
    }

    private int extractInt(String percentage) {
        return Integer.parseInt(percentage.replaceAll("%", ""));
    }
}

