/*
 * Decompiled with CFR 0.152.
 */
package jscover.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import jscover.maven.WebDriverRunnerBase;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class JasmineWebDriverRunner
extends WebDriverRunnerBase {
    @Override
    public void waitForTestsToComplete(WebDriver webClient) throws MojoExecutionException {
        new WebDriverWait(webClient, (long)this.timeOutSeconds).until((Function)ExpectedConditions.presenceOfElementLocated((By)By.className((String)"jasmine-duration")));
        new WebDriverWait(webClient, (long)this.timeOutSeconds).until((Function)ExpectedConditions.textToBePresentInElementLocated((By)By.className((String)"jasmine-duration"), (String)"finished"));
    }

    @Override
    public void verifyTestsPassed(WebDriver webClient) throws MojoFailureException {
        if (webClient.findElements(By.cssSelector((String)".jasmine-bar.jasmine-passed")).size() != 0) {
            return;
        }
        for (String failure : this.getFailures(webClient)) {
            this.log.error((CharSequence)failure);
        }
        throw new MojoFailureException("Failing on test");
    }

    @Override
    public List<String> getFailures(WebDriver webClient) {
        ArrayList<String> failures = new ArrayList<String>();
        List elements = webClient.findElements(By.className((String)"jasmine-failed"));
        for (WebElement element : elements) {
            List descriptions = element.findElements(By.className((String)"jasmine-description"));
            if (descriptions.size() != 1) continue;
            for (WebElement message : element.findElements(By.className((String)"jasmine-result-message"))) {
                failures.add(String.format("%s - %s", ((WebElement)descriptions.get(0)).getText(), message.getText()));
            }
        }
        return failures;
    }
}

