/*
 * Decompiled with CFR 0.152.
 */
package jscover.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import jscover.maven.WebDriverRunnerBase;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class MochaWebDriverRunner
extends WebDriverRunnerBase {
    @Override
    public void waitForTestsToComplete(WebDriver webClient) throws MojoExecutionException {
        new WebDriverWait(webClient, (long)this.timeOutSeconds).until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)By.className((String)"duration")));
    }

    @Override
    public void verifyTestsPassed(WebDriver webClient) throws MojoFailureException {
        if (webClient.findElements(By.className((String)"fail")).size() != 0) {
            for (String failure : this.getFailures(webClient)) {
                this.log.error((CharSequence)failure);
            }
            throw new MojoFailureException("Failing on test");
        }
    }

    @Override
    public List<String> getFailures(WebDriver webClient) {
        ArrayList<String> failures = new ArrayList<String>();
        List elements = webClient.findElements(By.className((String)"fail"));
        for (WebElement element : elements) {
            List descriptions = element.findElements(By.tagName((String)"h2"));
            String testName = ((WebElement)descriptions.get(0)).getText();
            for (WebElement message : element.findElements(By.className((String)"error"))) {
                failures.add(String.format("%s - %s", testName.substring(0, testName.length() - 2), message.getText().substring(0, message.getText().indexOf("\n"))));
            }
        }
        return failures;
    }
}

