/*
 * Decompiled with CFR 0.152.
 */
package jscover.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import jscover.maven.WebDriverRunnerBase;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class QUnitWebDriverRunner
extends WebDriverRunnerBase {
    @Override
    public void waitForTestsToComplete(WebDriver webClient) throws MojoExecutionException {
        new WebDriverWait(webClient, (long)this.timeOutSeconds).until((Function)ExpectedConditions.textToBePresentInElementLocated((By)By.id((String)"qunit-testresult"), (String)"tests completed"));
    }

    @Override
    public void verifyTestsPassed(WebDriver webClient) throws MojoFailureException {
        int failingCount = webClient.findElements(By.className((String)"fail")).size();
        if (failingCount != 0) {
            for (String failure : this.getFailures(webClient)) {
                this.log.error((CharSequence)failure);
            }
            throw new MojoFailureException("Number of failing tests: " + failingCount);
        }
    }

    @Override
    public List<String> getFailures(WebDriver webClient) {
        ArrayList<String> failures = new ArrayList<String>();
        List elements = webClient.findElements(By.className((String)"fail"));
        for (WebElement element : elements) {
            List descriptions = element.findElements(By.className((String)"test-name"));
            if (descriptions.size() != 1) continue;
            for (WebElement message : element.findElements(By.className((String)"test-source"))) {
                failures.add(String.format("%s - %s", ((WebElement)descriptions.get(0)).getText(), this.getTextViaJS(webClient, message)));
            }
        }
        return failures;
    }

    private String getTextViaJS(WebDriver webClient, WebElement webElement) {
        String script = "return arguments[0].innerText";
        return (String)((JavascriptExecutor)webClient).executeScript(script, new Object[]{webElement});
    }
}

