/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import java.util.Arrays;
import java.util.Map;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.collect.FluentIterable;
import wiremock.com.google.common.collect.Maps;

public class ExtensionLoader {
    public static <T> Map<String, T> loadExtension(String ... classNames) {
        return ExtensionLoader.asMap(FluentIterable.from(Arrays.asList(classNames)).transform(ExtensionLoader.toClasses()).transform(ExtensionLoader.toExtensions()));
    }

    public static Map<String, Extension> load(String ... classNames) {
        return ExtensionLoader.loadExtension(classNames);
    }

    public static Map<String, Extension> asMap(Iterable<Extension> extensions) {
        return Maps.uniqueIndex(extensions, new Function<Extension, String>(){

            @Override
            public String apply(Extension extension) {
                return extension.name();
            }
        });
    }

    public static Map<String, Extension> load(Class<? extends Extension> ... classes) {
        return ExtensionLoader.asMap(FluentIterable.from(Arrays.asList(classes)).transform(ExtensionLoader.toExtensions()));
    }

    private static Function<Class<? extends Extension>, Extension> toExtensions() {
        return new Function<Class<? extends Extension>, Extension>(){

            @Override
            public Extension apply(Class<? extends Extension> extensionClass) {
                try {
                    Preconditions.checkArgument(ResponseTransformer.class.isAssignableFrom(extensionClass), "Extension classes must implement ResponseTransformer");
                    return extensionClass.newInstance();
                }
                catch (Exception e) {
                    return Exceptions.throwUnchecked(e, Extension.class);
                }
            }
        };
    }

    private static Function<String, Class<? extends Extension>> toClasses() {
        return new Function<String, Class<? extends Extension>>(){

            @Override
            public Class<? extends Extension> apply(String className) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    return Exceptions.throwUnchecked(e, Class.class);
                }
            }
        };
    }
}

