/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.skyscreamer.jsonassert;

import wiremock.org.json.JSONArray;
import wiremock.org.json.JSONException;
import wiremock.org.json.JSONObject;
import wiremock.org.json.JSONString;

public class JSONParser {
    private static final String NUMBER_REGEX = "-?(?:0|[1-9]\\d*)(?:\\.\\d+)?(?:[eE][+-]?\\d+)?";

    private JSONParser() {
    }

    public static Object parseJSON(final String s) throws JSONException {
        if (s.trim().startsWith("{")) {
            return new JSONObject(s);
        }
        if (s.trim().startsWith("[")) {
            return new JSONArray(s);
        }
        if (s.trim().startsWith("\"") || s.trim().matches(NUMBER_REGEX)) {
            return new JSONString(){

                @Override
                public String toJSONString() {
                    return s;
                }
            };
        }
        throw new JSONException("Unparsable JSON string: " + s);
    }
}

