/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class ResponseDefinitionBuilder {
    protected int status = 200;
    protected byte[] bodyContent;
    protected boolean isBinaryBody = false;
    protected String bodyFileName;
    protected List<HttpHeader> headers = Lists.newArrayList();
    protected Integer fixedDelayMilliseconds;
    protected String proxyBaseUrl;
    protected Fault fault;
    protected List<String> responseTransformerNames;

    public static ResponseDefinitionBuilder like(ResponseDefinition responseDefinition) {
        ResponseDefinitionBuilder builder = new ResponseDefinitionBuilder();
        builder.status = responseDefinition.getStatus();
        builder.headers = responseDefinition.getHeaders() != null ? Lists.newArrayList(responseDefinition.getHeaders().all()) : Lists.newArrayList();
        builder.bodyContent = responseDefinition.getByteBody();
        builder.isBinaryBody = responseDefinition.specifiesBinaryBodyContent();
        builder.bodyFileName = responseDefinition.getBodyFileName();
        builder.fixedDelayMilliseconds = responseDefinition.getFixedDelayMilliseconds();
        builder.proxyBaseUrl = responseDefinition.getProxyBaseUrl();
        builder.fault = responseDefinition.getFault();
        builder.responseTransformerNames = responseDefinition.getTransformers();
        return builder;
    }

    public static ResponseDefinition jsonResponse(Object body) {
        return new ResponseDefinitionBuilder().withBody(Json.write(body)).withStatus(200).withHeader("Content-Type", "application/json").build();
    }

    public ResponseDefinitionBuilder but() {
        return this;
    }

    public ResponseDefinitionBuilder withStatus(int status) {
        this.status = status;
        return this;
    }

    public ResponseDefinitionBuilder withHeader(String key, String value) {
        this.headers.add(new HttpHeader(key, value));
        return this;
    }

    public ResponseDefinitionBuilder withBodyFile(String fileName) {
        this.bodyFileName = fileName;
        return this;
    }

    public ResponseDefinitionBuilder withBody(String body) {
        this.bodyContent = body.getBytes(Charset.forName(Charsets.UTF_8.name()));
        this.isBinaryBody = false;
        return this;
    }

    public ResponseDefinitionBuilder withBody(byte[] body) {
        this.bodyContent = body;
        this.isBinaryBody = true;
        return this;
    }

    public ResponseDefinitionBuilder withFixedDelay(Integer milliseconds) {
        this.fixedDelayMilliseconds = milliseconds;
        return this;
    }

    public ResponseDefinitionBuilder withTransformers(String ... responseTransformerNames) {
        this.responseTransformerNames = Arrays.asList(responseTransformerNames);
        return this;
    }

    public ProxyResponseDefinitionBuilder proxiedFrom(String proxyBaseUrl) {
        this.proxyBaseUrl = proxyBaseUrl;
        return new ProxyResponseDefinitionBuilder(this);
    }

    public ResponseDefinitionBuilder withFault(Fault fault) {
        this.fault = fault;
        return this;
    }

    public ResponseDefinition build() {
        ResponseDefinition response = this.isBinaryBody ? new ResponseDefinition(this.status, this.bodyContent) : (this.bodyContent == null ? new ResponseDefinition(this.status, (String)null) : new ResponseDefinition(this.status, new String(this.bodyContent, Charset.forName(Charsets.UTF_8.name()))));
        if (!this.headers.isEmpty()) {
            response.setHeaders(new HttpHeaders(this.headers));
        }
        response.setBodyFileName(this.bodyFileName);
        response.setFixedDelayMilliseconds(this.fixedDelayMilliseconds);
        response.setProxyBaseUrl(this.proxyBaseUrl);
        response.setFault(this.fault);
        response.setTransformers(this.responseTransformerNames);
        return response;
    }

    public static class ProxyResponseDefinitionBuilder
    extends ResponseDefinitionBuilder {
        private List<HttpHeader> additionalRequestHeaders = Lists.newArrayList();

        public ProxyResponseDefinitionBuilder(ResponseDefinitionBuilder from) {
            this.status = from.status;
            this.headers = from.headers;
            this.bodyContent = from.bodyContent;
            this.bodyFileName = from.bodyFileName;
            this.fault = from.fault;
            this.fixedDelayMilliseconds = from.fixedDelayMilliseconds;
            this.isBinaryBody = from.isBinaryBody;
            this.proxyBaseUrl = from.proxyBaseUrl;
            this.responseTransformerNames = from.responseTransformerNames;
        }

        public ProxyResponseDefinitionBuilder withAdditionalRequestHeader(String key, String value) {
            this.additionalRequestHeaders.add(new HttpHeader(key, value));
            return this;
        }

        @Override
        public ResponseDefinition build() {
            ResponseDefinition response = super.build();
            if (!this.additionalRequestHeaders.isEmpty()) {
                response.setAdditionalProxyRequestHeaders(new HttpHeaders(this.additionalRequestHeaders));
            }
            return response;
        }
    }
}

