/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.client.reporting.ReportingConfiguration;
import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.adwords.lib.utils.ReportResponseInterceptor;
import com.google.api.ads.common.lib.auth.AuthorizationHeaderProvider;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;

public class ReportRequestFactoryHelper {
    public static final String DOWNLOAD_SERVER_URI = "/api/adwords/reportdownload";
    private final AdWordsSession session;
    private final UserAgentCombiner userAgentCombiner;
    private final AuthorizationHeaderProvider authorizationHeaderProvider;
    private final HttpTransport httpTransport;
    private int reportDownloadTimeout;
    private final HttpResponseInterceptor responseInterceptor;

    ReportRequestFactoryHelper(AdWordsSession session) {
        this(session, AdWordsInternals.getInstance());
    }

    @VisibleForTesting
    ReportRequestFactoryHelper(AdWordsSession session, AdWordsInternals internals) {
        this(session, internals.getAuthorizationHeaderProvider(), internals.getUserAgentCombiner(), internals.getHttpTransport(), internals.getAdWordsLibConfiguration().getReportDownloadTimeout(), new ReportResponseInterceptor(internals.getAdWordsServiceLoggers().getReportServiceLogger()));
    }

    @VisibleForTesting
    ReportRequestFactoryHelper(AdWordsSession session, AuthorizationHeaderProvider authorizationHeaderProvider, UserAgentCombiner userAgentCombiner, HttpTransport httpTransport, int reportDownloadTimeout, HttpResponseInterceptor responseInterceptor) {
        this.session = session;
        this.authorizationHeaderProvider = authorizationHeaderProvider;
        this.userAgentCombiner = userAgentCombiner;
        this.httpTransport = httpTransport;
        this.reportDownloadTimeout = reportDownloadTimeout;
        this.responseInterceptor = responseInterceptor;
    }

    @VisibleForTesting
    HttpRequestFactory getHttpRequestFactory(String reportUrl, String version) throws AuthenticationException {
        final HttpHeaders httpHeaders = this.createHeaders(reportUrl, version);
        return this.httpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.setHeaders(httpHeaders);
                request.setConnectTimeout(ReportRequestFactoryHelper.this.reportDownloadTimeout);
                request.setReadTimeout(ReportRequestFactoryHelper.this.reportDownloadTimeout);
                request.setThrowExceptionOnExecuteError(false);
                request.setLoggingEnabled(true);
                request.setResponseInterceptor(ReportRequestFactoryHelper.this.responseInterceptor);
            }
        });
    }

    private HttpHeaders createHeaders(String reportUrl, String version) throws AuthenticationException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAuthorization(this.authorizationHeaderProvider.getAuthorizationHeader(this.session, reportUrl));
        httpHeaders.setUserAgent(this.userAgentCombiner.getUserAgent(this.session.getUserAgent()));
        httpHeaders.set("developerToken", (Object)this.session.getDeveloperToken());
        httpHeaders.set("clientCustomerId", (Object)this.session.getClientCustomerId());
        ReportingConfiguration reportingConfiguration = this.session.getReportingConfiguration();
        if (reportingConfiguration != null) {
            reportingConfiguration.validate(version);
            if (reportingConfiguration.isSkipReportHeader() != null) {
                httpHeaders.set("skipReportHeader", (Object)Boolean.toString(reportingConfiguration.isSkipReportHeader()));
            }
            if (reportingConfiguration.isSkipReportSummary() != null) {
                httpHeaders.set("skipReportSummary", (Object)Boolean.toString(reportingConfiguration.isSkipReportSummary()));
            }
        }
        return httpHeaders;
    }

    public int getReportDownloadTimeout() {
        return this.reportDownloadTimeout;
    }

    public void setReportDownloadTimeout(int reportDownloadTimeout) {
        this.reportDownloadTimeout = reportDownloadTimeout;
    }
}

